/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import org.apache.commons.collections.map.ReferenceMap;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.query.AbstractResultSet;
import org.openvpms.web.component.util.ErrorHelper;

public abstract class AbstractCachingResultSet<T>
extends AbstractResultSet<T> {
    private ReferenceMap cache = new ReferenceMap();
    private int count = -1;
    private boolean estimation = true;
    private int prefetchPages;
    private static final int PREFETCH = 4;

    public AbstractCachingResultSet(int pageSize) {
        this(pageSize, 4);
    }

    public AbstractCachingResultSet(int pageSize, int prefetchPages) {
        super(pageSize);
        this.prefetchPages = prefetchPages;
    }

    @Override
    public void reset() {
        this.cache.clear();
        this.count = -1;
        this.estimation = true;
        super.reset();
    }

    @Override
    public int getResults() {
        if (this.count == -1 || this.estimation) {
            this.count = this.countResults();
            this.estimation = false;
        }
        return this.count;
    }

    @Override
    public int getEstimatedResults() {
        return this.count == -1 ? 0 : this.count;
    }

    @Override
    public boolean isEstimatedActual() {
        return !this.estimation;
    }

    protected abstract IPage<T> query(int var1, int var2);

    protected abstract int countResults();

    @Override
    protected IPage<T> get(int page) {
        IPage<T> result = (IPage<T>)this.cache.get((Object)page);
        if (result == null) {
            boolean query = true;
            if (page > 0) {
                int pageSize = this.getPageSize();
                if (pageSize == -1) {
                    query = false;
                } else {
                    IPage previous = (IPage)this.cache.get((Object)(page - 1));
                    if (previous != null && previous.getResults().size() < pageSize) {
                        query = false;
                    }
                }
            }
            if (query) {
                result = this.query(page);
            }
        }
        return result;
    }

    protected IPage<T> query(int page) {
        int pageSize;
        Page result = null;
        int firstResult = this.getFirstResult(page);
        int maxResults = pageSize = this.getPageSize();
        int pages = 1;
        if (maxResults != -1 && this.prefetchPages != 0) {
            maxResults = pageSize * this.prefetchPages;
            pages = this.prefetchPages;
        }
        try {
            Page matches = this.query(firstResult, maxResults);
            List results = matches.getResults();
            if (results.isEmpty()) {
                this.cache.remove((Object)page);
            } else if (pages == 1) {
                result = matches;
                this.cache.put((Object)page, result);
            } else {
                for (int i = 0; i < pages; ++i) {
                    int from = i * pageSize;
                    if (from < results.size()) {
                        int to = from + pageSize >= results.size() ? results.size() : from + pageSize;
                        List subResults = results.subList(from, to);
                        Page subPage = new Page(subResults, firstResult + from, pageSize, this.count);
                        if (i == 0) {
                            result = subPage;
                        }
                        this.cache.put((Object)(page + i), (Object)subPage);
                        continue;
                    }
                    this.cache.remove((Object)i);
                }
            }
            if (matches.getTotalResults() != -1) {
                this.count = matches.getTotalResults();
                this.estimation = false;
            } else if (results.isEmpty()) {
                if (this.count > firstResult) {
                    this.count = firstResult - 1;
                    this.estimation = true;
                }
            } else {
                int lastResult = firstResult + results.size();
                if (lastResult > this.count) {
                    this.count = lastResult;
                    this.estimation = results.size() == maxResults;
                }
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
        return result;
    }
}

