/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class WeightRangeTableHelper {
    WeightRangeTableHelper() {
    }

    public static String getWeightRange(IMObject object) {
        return WeightRangeTableHelper.getWeightRange(ServiceHelper.getArchetypeService().getBean(object));
    }

    public static String getWeightRange(IMObjectBean bean) {
        BigDecimal min = bean.getBigDecimal("minWeight", BigDecimal.ZERO);
        BigDecimal max = bean.getBigDecimal("maxWeight", BigDecimal.ZERO);
        if (MathRules.isZero((BigDecimal)min) && MathRules.isZero((BigDecimal)max)) {
            return null;
        }
        String units = LookupNameHelper.getName(bean.getObject(), "weightUnits");
        return Messages.format((String)"product.weightrange", (Object[])new Object[]{min, max, units});
    }
}

