/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.button.ButtonGroup;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.TaskRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutableProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductTaskEditor
extends EntityLinkEditor {
    private final TaskRules rules = ServiceHelper.getBean(TaskRules.class);
    static final String START = "start";
    static final String START_UNITS = "startUnits";
    static final String WORK_LIST = "worklist";

    public ProductTaskEditor(EntityLink object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateWorklist(validator);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    @Override
    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        return new PropertySetBuilder(object, archetype, variables).mutable(START).mutable(START_UNITS).mutable(WORK_LIST).build();
    }

    private boolean validateWorklist(Validator validator) {
        Entity taskType = (Entity)this.getTargetEditor().getObject();
        Property property = this.getProperty(WORK_LIST);
        Reference reference = property.getReference();
        if (reference != null) {
            Entity worklist = (Entity)this.getObject(reference);
            if (worklist == null) {
                validator.add((Modifiable)property, Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getDisplayName("party.organisationWorkList")}));
            } else if (!worklist.isActive()) {
                validator.add((Modifiable)property, Messages.format((String)"product.task.inactiveWorklist", (Object[])new Object[]{worklist.getName()}));
            } else if (!this.rules.hasTaskType(worklist, taskType)) {
                validator.add((Modifiable)property, Messages.format((String)"product.task.invalidWorklist", (Object[])new Object[]{worklist.getName(), taskType.getName()}));
            }
        }
        return validator.isValid();
    }

    private static class LayoutStrategy
    extends AbstractLayoutStrategy {
        public LayoutStrategy() {
            super(ArchetypeNodes.all().exclude(ProductTaskEditor.START_UNITS));
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            this.addComponent(this.createStart(object, properties, context));
            this.addComponent(this.createWorkList(object, properties, context));
            return super.apply(object, properties, parent, context);
        }

        private ComponentState createStart(IMObject object, PropertySet properties, LayoutContext context) {
            MutableProperty start = (MutableProperty)properties.get(ProductTaskEditor.START);
            MutableProperty startUnits = (MutableProperty)properties.get(ProductTaskEditor.START_UNITS);
            ComponentState startComponent = this.createComponentPair(start, startUnits, object, context);
            ButtonGroup group = new ButtonGroup();
            RadioButton button1 = ButtonFactory.create((String)"product.task.startWhenInvoiced", (ButtonGroup)group, () -> {
                start.setValue(null);
                start.setRequired(false);
                startUnits.setRequired(false);
            });
            RadioButton button2 = ButtonFactory.create(null, (ButtonGroup)group, () -> {
                start.setRequired(true);
                startUnits.setRequired(true);
                if (startUnits.getString() == null) {
                    startUnits.setValue(DateUnits.DAYS.toString());
                }
                startComponent.getFocusGroup().setFocus();
            });
            if (start.getInt() == 0) {
                button1.setSelected(true);
            } else {
                button2.setSelected(true);
            }
            start.addModifiableListener(modifiable -> {
                if (start.getValue() == null) {
                    button1.setSelected(true);
                } else {
                    button2.setSelected(true);
                }
            });
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button2, startComponent.getComponent(), LabelFactory.create((String)"product.task.startAfterInvoicing")});
            Column column = ColumnFactory.create((Component[])new Component[]{button1, row});
            FocusGroup focus = new FocusGroup(ProductTaskEditor.START);
            focus.add((Component)button1);
            focus.add((Component)button2);
            focus.add(startComponent.getFocusGroup());
            ComponentState result = new ComponentState((Component)column, start, focus);
            result.getLabel().setLayoutData((LayoutData)ComponentGrid.layout(Alignment.ALIGN_TOP));
            return result;
        }

        private ComponentState createWorkList(IMObject object, PropertySet properties, LayoutContext context) {
            final Relationship relationship = (Relationship)object;
            MutableProperty worklist = (MutableProperty)properties.get(ProductTaskEditor.WORK_LIST);
            DefaultIMObjectReferenceEditor<Entity> worklistEditor = new DefaultIMObjectReferenceEditor<Entity>((Property)worklist, object, context){

                @Override
                protected Query<Entity> createQuery(String name) {
                    Query<Entity> query = super.createQuery(name);
                    if (relationship.getTarget() != null) {
                        query.setConstraints((IConstraint)Constraints.join((String)"taskTypes").add((IConstraint)Constraints.eq((String)"target", (Reference)relationship.getTarget())));
                    }
                    return query;
                }
            };
            ButtonGroup group = new ButtonGroup();
            RadioButton button1 = ButtonFactory.create((String)"product.task.useFollowUp", (ButtonGroup)group, () -> {
                worklist.setValue(null);
                worklist.setRequired(false);
            });
            RadioButton button2 = ButtonFactory.create(null, (ButtonGroup)group, () -> worklist.setRequired(true));
            if (worklist.getReference() == null) {
                button1.setSelected(true);
            } else {
                button2.setSelected(true);
            }
            worklist.addModifiableListener(modifiable -> {
                if (worklist.getReference() != null) {
                    button2.setSelected(true);
                } else {
                    button1.setSelected(true);
                }
            });
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button2, worklistEditor.getComponent()});
            Column column = ColumnFactory.create((Component[])new Component[]{button1, row});
            FocusGroup focus = new FocusGroup(ProductTaskEditor.WORK_LIST);
            focus.add((Component)button1);
            focus.add((Component)button2);
            focus.add(worklistEditor.getFocusGroup());
            ComponentState result = new ComponentState((Component)column, worklist, focus);
            result.getLabel().setLayoutData((LayoutData)ComponentGrid.layout(Alignment.ALIGN_TOP));
            return result;
        }
    }
}

