/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingContextFactory;
import org.openvpms.web.component.im.product.ProductPricingContext;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

public class ProductTableModel
extends BaseIMObjectTableModel<Product> {
    private final ProductPricingContext pricingContext;
    private int fixedPriceIndex;
    private int unitPriceIndex;
    private boolean showActive;

    public ProductTableModel(LayoutContext context) {
        this(null, context);
    }

    public ProductTableModel(ProductQuery query, LayoutContext context) {
        this(query, context.getContext().getLocation(), context);
    }

    public ProductTableModel(ProductQuery query, Party location, LayoutContext context) {
        super(null);
        Party practice = context.getContext().getPractice();
        PricingContextFactory factory = ServiceHelper.getBean(PricingContextFactory.class);
        this.pricingContext = query != null ? factory.createProductPricingContext(query.getPricingGroup(), practice, location) : factory.createProductPricingContext(practice, location);
        this.showActive = query == null || query.getActive() == BaseArchetypeConstraint.State.BOTH;
        this.setTableColumnModel(this.createTableColumnModel(this.showActive));
    }

    public void setShowActive(boolean show) {
        if (show != this.showActive) {
            this.showActive = show;
            this.setTableColumnModel(this.createTableColumnModel(this.showActive));
        }
    }

    public void setPricingGroup(Lookup pricingGroup) {
        if (!Objects.equals(this.pricingContext.getPricingGroup().getGroup(), pricingGroup)) {
            this.pricingContext.setPricingGroup(new PricingGroup(pricingGroup));
            this.fireTableDataChanged();
        }
    }

    @Override
    protected Object getValue(Product product, TableColumn column, int row) {
        int index = column.getModelIndex();
        if (index == this.fixedPriceIndex) {
            return this.getFixedPrice(product);
        }
        if (index == this.unitPriceIndex) {
            return this.getUnitPrice(product);
        }
        return super.getValue(product, column, row);
    }

    @Override
    protected TableColumnModel createTableColumnModel(boolean active) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(ProductTableModel.createTableColumn(1, "table.imobject.id"));
        model.addColumn(ProductTableModel.createTableColumn(3, "table.imobject.name"));
        model.addColumn(ProductTableModel.createTableColumn(4, "table.imobject.description"));
        model.addColumn(ProductTableModel.createTableColumn(2, "table.imobject.archetype"));
        this.fixedPriceIndex = this.getNextModelIndex((TableColumnModel)model);
        this.unitPriceIndex = this.fixedPriceIndex + 1;
        TableColumn fixedPrice = ProductTableModel.createTableColumn(this.fixedPriceIndex, "producttablemodel.fixedPrice");
        TableColumn unitPrice = ProductTableModel.createTableColumn(this.unitPriceIndex, "producttablemodel.unitPrice");
        model.addColumn(fixedPrice);
        model.addColumn(unitPrice);
        if (active) {
            model.addColumn(ProductTableModel.createTableColumn(5, "table.imobject.active"));
        }
        return model;
    }

    private Component getFixedPrice(Product product) {
        ProductPrice price = this.pricingContext.getFixedPrice(product, new Date());
        return this.getPrice(product, price);
    }

    private Component getUnitPrice(Product product) {
        ProductPrice price = this.pricingContext.getUnitPrice(product, new Date());
        return this.getPrice(product, price);
    }

    private Component getPrice(Product product, ProductPrice price) {
        Label result = null;
        if (price != null) {
            BigDecimal value = this.pricingContext.getPrice(product, price, BigDecimal.ONE);
            result = TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)value));
        }
        return result;
    }
}

