/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.system.ServiceHelper;

public class ProductReminderRelationshipEditor
extends EntityLinkEditor {
    public ProductReminderRelationshipEditor(EntityLink relationship, IMObject parent, LayoutContext context) {
        super((org.openvpms.component.model.entity.EntityLink)relationship, parent, context);
        this.getTarget().addModifiableListener(modifiable -> this.onReminderTypeChanged());
    }

    private void onReminderTypeChanged() {
        IMObjectReference reference = (IMObjectReference)this.getTarget().getValue();
        Entity reminderType = (Entity)this.getObject((Reference)reference);
        if (reminderType != null) {
            ReminderType type = new ReminderType(reminderType, (ArchetypeService)ServiceHelper.getArchetypeService());
            this.getProperty("period").setValue(type.getDefaultInterval());
            this.getProperty("periodUom").setValue(type.getDefaultUnits().toString());
            this.getProperty("interactive").setValue(type.isInteractive());
        }
    }
}

