/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;

public class ProductPriceTableModel
extends DescriptorTableModel<IMObject> {
    private final int pricingGroupIndex = this.getNextModelIndex(this.getColumnModel());
    private final ProductPriceRules rules = ServiceHelper.getBean(ProductPriceRules.class);
    private boolean showPricingGroups;

    public ProductPriceTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
        int fromDate = this.getModelIndex(this.getColumnModel(), "fromDate");
        this.setDefaultSortColumn(fromDate);
        this.setDefaultSortAscending(false);
    }

    public void setShowPricingGroups(boolean show) {
        if (this.showPricingGroups != show) {
            this.showPricingGroups = show;
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.getColumnModel();
            if (show) {
                model.addColumn(ProductPriceTableModel.createTableColumn(this.pricingGroupIndex, "product.pricingGroup"));
            } else {
                model.removeColumn(this.getColumn(this.pricingGroupIndex));
            }
            this.fireTableStructureChanged();
        }
    }

    @Override
    protected Object getValue(IMObject object, TableColumn column, int row) {
        Object result = null;
        if (column.getModelIndex() == this.pricingGroupIndex) {
            List pricingGroups = this.rules.getPricingGroups((ProductPrice)object);
            int size = pricingGroups.size();
            if (size == 1) {
                result = ((Lookup)pricingGroups.get(0)).getName();
            } else if (size > 1) {
                pricingGroups.sort(IMObjectSorter.getNameComparator(true));
                Column col = ColumnFactory.create();
                for (Lookup lookup : pricingGroups) {
                    Label label = LabelFactory.create();
                    label.setText(lookup.getName());
                    col.add((Component)label);
                }
                result = col;
            }
        } else {
            result = super.getValue(object, column, row);
        }
        return result;
    }
}

