/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.component.im.product.WeightRangeTableHelper;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.system.ServiceHelper;

public class ProductIncludesRelationshipStateTableModel
extends RelationshipStateTableModel {
    private static final int LOW_QUANTITY_INDEX = 5;
    private static final int HIGH_QUANTITY_INDEX = 6;
    private static final int WEIGHT_INDEX = 7;
    private static final int SKIP_INDEX = 8;
    private static final int ZERO_PRICE_INDEX = 9;
    private static final int PRINT_INDEX = 10;

    public ProductIncludesRelationshipStateTableModel(LayoutContext context) {
        super(context, true);
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    @Override
    protected Object getValue(RelationshipState object, TableColumn column, int row) {
        Object result = column instanceof DescriptorTableColumn ? ((DescriptorTableColumn)column).getComponent((IMObject)object.getRelationship(), this.getContext()) : (column.getModelIndex() == 7 ? WeightRangeTableHelper.getWeightRange(object.getBean()) : super.getValue(object, column, row));
        return result;
    }

    @Override
    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor("entityLink.productIncludes");
        model.addColumn(ProductIncludesRelationshipStateTableModel.createTableColumn(1, "table.imobject.name"));
        model.addColumn((TableColumn)new DescriptorTableColumn(5, "lowQuantity", (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype));
        model.addColumn((TableColumn)new DescriptorTableColumn(6, "highQuantity", (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype));
        model.addColumn(ProductIncludesRelationshipStateTableModel.createTableColumn(7, "product.weight"));
        if (ProductHelper.useLocationProducts(this.getContext().getContext())) {
            model.addColumn((TableColumn)new DescriptorTableColumn(8, "skipIfMissing", (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype));
        }
        model.addColumn((TableColumn)new DescriptorTableColumn(9, "zeroPrice", (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype));
        model.addColumn((TableColumn)new DescriptorTableColumn(10, "print", (Object)true, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype));
        if (this.getShowActive()) {
            model.addColumn(ProductIncludesRelationshipStateTableModel.createTableColumn(4, "table.imobject.active"));
        }
        return model;
    }
}

