/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.system.ServiceHelper;

public class ProductHelper {
    public static boolean useLocationProducts(Party practice) {
        PracticeRules rules = ServiceHelper.getBean(PracticeRules.class);
        return rules.useLocationProducts(practice);
    }

    public static boolean useLocationProducts(Context context) {
        Party practice = context.getPractice();
        return practice != null && ProductHelper.useLocationProducts(practice);
    }

    public static PricingGroup getPricingGroup(Context context) {
        Lookup result = null;
        Party location = context.getLocation();
        if (location != null) {
            LocationRules rules = ServiceHelper.getBean(LocationRules.class);
            result = rules.getPricingGroup(location);
        }
        return result != null ? new PricingGroup(result) : PricingGroup.NONE;
    }

    public static List<IMObject> filterPrices(List<IMObject> prices, PricingGroup pricingGroup) {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        for (IMObject object : prices) {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean(object);
            List groups = bean.getValues("pricingGroups", Lookup.class);
            if (pricingGroup == null) {
                if (!groups.isEmpty()) continue;
                result.add(object);
                continue;
            }
            if (!pricingGroup.matches((Collection)groups)) continue;
            result.add(object);
        }
        return result;
    }

    public static boolean pricingGroupsConfigured() {
        return !ProductHelper.getPricingGroups().isEmpty();
    }

    public static Collection<Lookup> getPricingGroups() {
        return ServiceHelper.getLookupService().getLookups("lookup.pricingGroup");
    }

    public static boolean hasPricingGroups(ProductPrice price) {
        ProductPriceRules rules = ServiceHelper.getBean(ProductPriceRules.class);
        return !rules.getPricingGroups(price).isEmpty();
    }
}

