/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceUpdater;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductLocationCollectionEditor;
import org.openvpms.web.component.im.product.ProductPriceCollectionEditor;
import org.openvpms.web.component.im.product.ProductPriceEditor;
import org.openvpms.web.component.im.product.ProductStockLocationEditor;
import org.openvpms.web.component.im.relationship.MultipleEntityLinkCollectionEditor;
import org.openvpms.web.component.im.relationship.RelationshipCollectionEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.NoOpPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductEditor
extends AbstractIMObjectEditor {
    private final ProductPriceUpdater updater;
    private final Map<Reference, BigDecimal> supplierCostPrices = new HashMap<Reference, BigDecimal>();
    private static final String CONCENTRATION = "concentration";
    private static final String PRICES = "prices";
    private static final String DOSES = "doses";
    private static final String STOCK_LOCATIONS = "stockLocations";
    private static final String LOCATIONS = "locations";
    private static final String SUPPLIERS = "suppliers";
    private static final String PREFERRED = "preferred";

    public ProductEditor(Product object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        CollectionProperty suppliers = this.getCollectionProperty(SUPPLIERS);
        CollectionProperty stockLocations = this.getCollectionProperty(STOCK_LOCATIONS);
        CollectionProperty locations = this.getCollectionProperty(LOCATIONS);
        if (suppliers != null && stockLocations != null) {
            this.initCostPrices(suppliers);
            this.initStockLocations(object, stockLocations);
        }
        if (locations != null) {
            this.addEditor(new ProductLocationCollectionEditor(locations, (Entity)object, this.getLayoutContext()));
        }
        this.updater = new ProductPriceUpdater(ServiceHelper.getBean(ProductPriceRules.class), ServiceHelper.getBean(PracticeRules.class), this.getService());
        Property instructions = this.getProperty("dispInstructions");
        if (instructions != null) {
            instructions.setTransformer(NoOpPropertyTransformer.INSTANCE);
        }
    }

    public List<ProductPrice> getPrices() {
        ArrayList<ProductPrice> prices = new ArrayList<ProductPrice>();
        for (IMObject object : this.getPricesEditor().getCurrentObjects()) {
            prices.add((ProductPrice)object);
        }
        prices.sort((o1, o2) -> {
            int compare = DateRules.compareTo((Date)o1.getFromDate(), (Date)o2.getFromDate());
            if (compare == 0) {
                compare = Long.compare(o1.getId(), o2.getId());
            }
            return compare;
        });
        return prices;
    }

    public ProductPriceCollectionEditor getPricesEditor() {
        return (ProductPriceCollectionEditor)this.getEditor(PRICES, false);
    }

    public EditableIMObjectCollectionEditor getSuppliersEditor() {
        return (EditableIMObjectCollectionEditor)this.getEditor(SUPPLIERS, false);
    }

    public EditableIMObjectCollectionEditor getStockLocationsEditor() {
        return (EditableIMObjectCollectionEditor)this.getEditor(STOCK_LOCATIONS, false);
    }

    public List<Reference> getSuppliers() {
        ArrayList<Reference> result = new ArrayList<Reference>();
        EditableIMObjectCollectionEditor suppliers = this.getSuppliersEditor();
        if (suppliers != null) {
            for (IMObject object : suppliers.getCurrentObjects()) {
                Relationship relationship = (Relationship)object;
                Reference target = relationship.getTarget();
                if (target == null) continue;
                result.add(target);
            }
        }
        return result;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            valid = this.validateDoses(validator) && this.validateSuppliers(validator);
        }
        return valid;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        ProductLocationCollectionEditor locations;
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        RelationshipCollectionEditor stockLocations = (RelationshipCollectionEditor)this.getEditor(STOCK_LOCATIONS, false);
        if (stockLocations != null) {
            strategy.addComponent(new ComponentState(stockLocations));
        }
        if ((locations = (ProductLocationCollectionEditor)this.getEditor(LOCATIONS, false)) != null) {
            strategy.addComponent(new ComponentState(locations));
        }
        return strategy;
    }

    @Override
    protected void onLayoutCompleted() {
        EditableIMObjectCollectionEditor editor = this.getSuppliersEditor();
        if (editor != null) {
            editor.addModifiableListener(modifiable -> this.onSupplierChanged());
        }
    }

    private void initCostPrices(CollectionProperty suppliers) {
        for (Object object : suppliers.getValues()) {
            Relationship relationship = (Relationship)object;
            ProductSupplier ps = new ProductSupplier(relationship, this.getService());
            if (!ps.isAutoPriceUpdate()) continue;
            this.supplierCostPrices.put(relationship.getObjectReference(), ps.getCostPrice());
        }
    }

    private void initStockLocations(Product object, CollectionProperty stockLocations) {
        MultipleEntityLinkCollectionEditor relationshipCollectionEditor = new MultipleEntityLinkCollectionEditor(stockLocations, (Entity)object, this.getLayoutContext()){

            @Override
            protected IMObjectEditor createEditor(IMObject object, LayoutContext context) {
                IMObjectEditor editor = super.createEditor(object, context);
                if (editor instanceof ProductStockLocationEditor) {
                    ((ProductStockLocationEditor)editor).setProductEditor(ProductEditor.this);
                }
                return editor;
            }
        };
        for (IMObject relationship : relationshipCollectionEditor.getCurrentObjects()) {
            relationshipCollectionEditor.getEditor(relationship);
        }
        this.addEditor(relationshipCollectionEditor);
    }

    private void onSupplierChanged() {
        this.updateUnitPrices();
        this.updatePreferred();
        RelationshipCollectionEditor stockLocations = (RelationshipCollectionEditor)this.getEditor(STOCK_LOCATIONS, false);
        if (stockLocations != null) {
            stockLocations.resetValid();
        }
    }

    private void updateUnitPrices() {
        EditableIMObjectCollectionEditor suppliers = this.getSuppliersEditor();
        ProductPriceCollectionEditor prices = this.getPricesEditor();
        if (suppliers != null && prices != null) {
            boolean updated = false;
            for (IMObjectEditor editor : suppliers.getEditors()) {
                Relationship rel = (Relationship)editor.getObject();
                ProductSupplier supplier = new ProductSupplier(rel, this.getService());
                if (supplier.isAutoPriceUpdate()) {
                    updated |= this.updatePrices(prices, supplier);
                    continue;
                }
                this.supplierCostPrices.remove(rel.getObjectReference());
            }
            if (updated) {
                prices.refresh();
            }
        }
    }

    private boolean updatePrices(EditableIMObjectCollectionEditor prices, ProductSupplier productSupplier) {
        boolean result = false;
        IMObjectReference reference = productSupplier.getRelationship().getObjectReference();
        BigDecimal existingCost = this.supplierCostPrices.get(reference);
        BigDecimal costPrice = productSupplier.getCostPrice();
        if (existingCost == null || !MathRules.equals((BigDecimal)existingCost, (BigDecimal)costPrice)) {
            IMObjectEditor current = prices.getCurrentEditor();
            if (current != null && !prices.getCollection().getValues().contains(current.getObject())) {
                prices.add(current.getObject());
            }
            Collection<IMObjectEditor> currentPrices = prices.getEditors();
            List updated = this.updater.update((Product)this.getObject(), productSupplier, false);
            if (!updated.isEmpty()) {
                for (ProductPrice price : updated) {
                    if (price.isNew()) {
                        String name = this.getName((Reference)productSupplier.getSupplierRef());
                        IMObjectBean bean = this.getBean((IMObject)price);
                        bean.setValue("notes", (Object)Messages.format((String)"product.price.autoupdate", (Object[])new Object[]{name}));
                    }
                    if (price.getProduct() == null) {
                        prices.add((IMObject)price);
                        continue;
                    }
                    this.updatePriceEditor(price, currentPrices);
                }
                this.supplierCostPrices.put((Reference)reference, costPrice);
                result = true;
            }
        }
        return result;
    }

    private void updatePriceEditor(ProductPrice price, Collection<IMObjectEditor> editors) {
        for (IMObjectEditor editor : editors) {
            if (!editor.getObject().equals(price) || !(editor instanceof ProductPriceEditor)) continue;
            ((ProductPriceEditor)editor).refresh();
            break;
        }
    }

    private boolean validateDoses(Validator validator) {
        boolean result = true;
        EditableIMObjectCollectionEditor editor = (EditableIMObjectCollectionEditor)this.getEditor(DOSES);
        if (editor != null) {
            result = this.validateConcentration(editor, validator) && this.validateDoses(editor, validator);
        }
        return result;
    }

    private boolean validateConcentration(EditableIMObjectCollectionEditor doses, Validator validator) {
        Property property;
        BigDecimal concentration;
        boolean result = true;
        if (!doses.getCurrentObjects().isEmpty() && MathRules.isZero((BigDecimal)(concentration = (property = this.getProperty(CONCENTRATION)).getBigDecimal(BigDecimal.ZERO)))) {
            result = false;
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"product.concentration.required", (Object[])new Object[0])));
        }
        return result;
    }

    private boolean validateDoses(EditableIMObjectCollectionEditor editor, Validator validator) {
        Lookup all = new Lookup();
        LinkedHashMap<org.openvpms.component.model.lookup.Lookup, List> dosesBySpecies = new LinkedHashMap<org.openvpms.component.model.lookup.Lookup, List>();
        for (IMObject iMObject : editor.getCurrentObjects()) {
            IMObjectBean bean = this.getBean(iMObject);
            List values = bean.getValues("species", org.openvpms.component.model.lookup.Lookup.class);
            Lookup species = !values.isEmpty() ? (org.openvpms.component.model.lookup.Lookup)values.get(0) : all;
            List doses = dosesBySpecies.computeIfAbsent((org.openvpms.component.model.lookup.Lookup)species, k -> new ArrayList());
            doses.add(iMObject);
        }
        for (Map.Entry entry : dosesBySpecies.entrySet()) {
            ArrayList doses = new ArrayList((Collection)entry.getValue());
            while (doses.size() > 1) {
                IMObjectBean dose = this.getBean((IMObject)doses.remove(0));
                BigDecimal minWeight = dose.getBigDecimal("minWeight", BigDecimal.ZERO);
                BigDecimal maxWeight = dose.getBigDecimal("maxWeight", BigDecimal.ZERO);
                WeightUnits units = WeightUnits.fromString((String)dose.getString("weightUnits"));
                for (IMObject otherDose : doses) {
                    IMObjectBean other = this.getBean(otherDose);
                    BigDecimal otherMinWeight = other.getBigDecimal("minWeight", BigDecimal.ZERO);
                    BigDecimal otherMaxWeight = other.getBigDecimal("maxWeight", BigDecimal.ZERO);
                    WeightUnits otherUnits = WeightUnits.fromString((String)other.getString("weightUnits"));
                    if (units != null && otherUnits != null && !units.equals((Object)otherUnits)) {
                        otherMinWeight = Weight.convert((BigDecimal)otherMinWeight, (WeightUnits)otherUnits, (WeightUnits)units);
                        otherMaxWeight = Weight.convert((BigDecimal)otherMaxWeight, (WeightUnits)otherUnits, (WeightUnits)units);
                    }
                    if (!MathRules.intersects((BigDecimal)minWeight, (BigDecimal)maxWeight, (BigDecimal)otherMinWeight, (BigDecimal)otherMaxWeight)) continue;
                    validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"product.dose.weightOverlap", (Object[])new Object[]{dose.getObject().getName(), otherDose.getName()})));
                    return false;
                }
            }
        }
        return true;
    }

    private void updatePreferred() {
        IMObjectEditor currentEditor;
        EditableIMObjectCollectionEditor suppliers = this.getSuppliersEditor();
        if (suppliers != null && (currentEditor = suppliers.getCurrentEditor()) != null && currentEditor.getProperty(PREFERRED).getBoolean()) {
            for (IMObject object : suppliers.getCurrentObjects()) {
                Property preferred;
                IMObjectEditor editor;
                if (object.equals(currentEditor.getObject()) || (editor = suppliers.getEditor(object)) == null || !(preferred = editor.getProperty(PREFERRED)).getBoolean()) continue;
                preferred.setValue(false);
            }
        }
    }

    private boolean validateSuppliers(Validator validator) {
        boolean valid = true;
        EditableIMObjectCollectionEditor editor = this.getSuppliersEditor();
        if (editor != null) {
            Reference preferred = null;
            for (IMObject object : editor.getCurrentObjects()) {
                Relationship relationship = (Relationship)object;
                IMObjectBean bean = this.getBean((IMObject)relationship);
                if (!bean.getBoolean(PREFERRED)) continue;
                if (preferred != null) {
                    IMObject first = this.getObject(preferred);
                    IMObject second = this.getObject(relationship.getTarget());
                    String firstName = first != null ? first.getName() : null;
                    String secondName = second != null ? second.getName() : null;
                    String message = Messages.format((String)"product.supplier.multiplepreferred", (Object[])new Object[]{firstName, secondName});
                    validator.add((Modifiable)editor.getProperty(), new ValidatorError(editor.getProperty(), message));
                    valid = false;
                    break;
                }
                preferred = relationship.getTarget();
            }
        }
        return valid;
    }
}

