/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.bound.BoundTextField;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductBatchResultSet;
import org.openvpms.web.component.im.product.ProductBatchTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class BatchReferenceEditor
extends AbstractPropertyEditor
implements IMObjectReferenceEditor<Entity> {
    private final boolean setDefault;
    private final LayoutContext context;
    private final FocusGroup focusGroup;
    private final SimpleProperty input;
    private final ModifiableListener listener;
    private final DropDown dropDown;
    private Product product;
    private Reference stockLocation;
    private Entity batch;
    private Date expiryDate;

    public BatchReferenceEditor(Property property, boolean setDefault, LayoutContext context) {
        super(property);
        this.setDefault = setDefault;
        this.context = context;
        this.focusGroup = new FocusGroup(this.getClass().getSimpleName());
        this.input = new SimpleProperty(property.getName(), null, String.class, property.getDisplayName());
        this.input.setDescription(property.getDescription());
        BoundTextField inputField = new BoundTextField(this.input);
        inputField.setStyleName("Selector");
        this.dropDown = new DropDown();
        this.dropDown.setStyleName("default");
        this.dropDown.setTarget((Component)inputField);
        this.dropDown.setPopUpAlwaysOnTop(true);
        this.dropDown.setFocusOnExpand(true);
        this.batch = this.getObject();
        this.listener = modifiable -> this.updateBatches(true);
        this.updateText();
    }

    public void setProduct(Product product) {
        if (this.batch != null && product != null && !this.hasRelationship(this.batch, product)) {
            this.setObject((Entity)null);
        }
        this.product = product;
        this.updateBatches(false);
    }

    public void setExpireAfter(Date date) {
        this.expiryDate = date;
        this.updateBatches(false);
    }

    @Override
    public Component getComponent() {
        return this.dropDown;
    }

    @Override
    public boolean setObject(Entity object) {
        Reference ref = object != null ? object.getObjectReference() : null;
        this.batch = object;
        this.updateText();
        return this.getProperty().setValue(ref);
    }

    @Override
    public Entity getObject() {
        Property property = this.getProperty();
        IMObjectReference reference = (IMObjectReference)property.getValue();
        Entity object = null;
        if (reference != null) {
            object = (Entity)this.context.getCache().get((Reference)reference);
        }
        return object;
    }

    @Override
    public boolean isNull() {
        return this.getProperty().getValue() == null && StringUtils.isEmpty((CharSequence)this.input.getString());
    }

    @Override
    public void setAllowCreate(boolean create) {
    }

    @Override
    public boolean allowCreate() {
        return false;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public void setStockLocation(Reference stockLocation) {
        this.stockLocation = stockLocation;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.isValidReference(validator);
    }

    protected boolean isValidReference(Validator validator) {
        boolean result = true;
        if (this.batch != null && this.product != null && !this.hasRelationship(this.batch, this.product)) {
            result = false;
            String displayName = DescriptorHelper.getDisplayName((String)this.batch.getArchetype(), (ArchetypeService)ServiceHelper.getArchetypeService());
            String message = Messages.format((String)"imobject.invalidreference", (Object[])new Object[]{displayName});
            validator.add((Modifiable)this, new ValidatorError(this.getProperty(), message));
        }
        return result;
    }

    private void updateText() {
        try {
            this.input.removeModifiableListener(this.listener);
            if (this.batch != null) {
                this.input.setValue(this.batch.getName());
            } else {
                this.input.setValue(null);
            }
        }
        finally {
            this.input.addModifiableListener(this.listener);
        }
    }

    private void updateBatches(boolean showPopup) {
        PagedIMTable<Entity> table = null;
        if (this.product != null && this.expiryDate != null) {
            boolean useDefault = showPopup || this.setDefault;
            String batchNumber = this.input.getString();
            if (this.batch != null && this.batch.getName().equals(batchNumber)) {
                batchNumber = null;
            } else if (this.batch != null && batchNumber == null) {
                useDefault = false;
                this.setObject((Entity)null);
            } else if (batchNumber != null && !batchNumber.endsWith("*")) {
                batchNumber = batchNumber + "*";
            }
            ProductBatchResultSet set = new ProductBatchResultSet(batchNumber, this.product, this.expiryDate, this.stockLocation, 5);
            if (set.hasNext()) {
                IPage next = set.next();
                List results = next.getResults();
                if (results.size() >= 1) {
                    set.previous();
                    table = this.createTable(set);
                    if (useDefault && (this.batch == null || results.size() == 1)) {
                        this.setObject((Entity)results.get(0));
                        showPopup = false;
                    }
                }
            } else if (!StringUtils.isEmpty((CharSequence)batchNumber) && (set = new ProductBatchResultSet(null, this.product, this.expiryDate, this.stockLocation, 5)).hasNext()) {
                table = this.createTable(set);
            }
        }
        if (table != null) {
            table.getTable().setSelected(this.batch);
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{table.getComponent()});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(table.getComponent());
        } else {
            Label component = LabelFactory.create((String)"imobject.none");
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{component});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(null);
        }
        if (showPopup) {
            this.dropDown.setExpanded(true);
        }
    }

    private PagedIMTable<Entity> createTable(ProductBatchResultSet set) {
        ProductBatchTableModel model = new ProductBatchTableModel(this.context, false, false);
        final PagedIMTable<Entity> table = new PagedIMTable<Entity>(model, set);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                BatchReferenceEditor.this.setObject((Entity)table.getTable().getSelected());
                BatchReferenceEditor.this.dropDown.setExpanded(false);
            }
        });
        return table;
    }

    private boolean hasRelationship(Entity batch, Product product) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)batch);
        return Objects.equals(bean.getTargetRef("product"), product.getObjectReference());
    }
}

