/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.customer.CustomerPatientObjectSetQuery;
import org.openvpms.web.component.im.patient.PatientResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.text.TextComponent;

public class PatientByCustomerObjectSetQuery
extends CustomerPatientObjectSetQuery {
    protected static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("customer", "name"), new NodeSortConstraint("customer", "id"), new NodeSortConstraint("patient", "name"), new NodeSortConstraint("patient", "id")};

    public PatientByCustomerObjectSetQuery(String[] shortNames, Party customer) {
        super(shortNames, false, customer);
        this.setDefaultSortConstraint(DEFAULT_SORT);
    }

    @Override
    public boolean selects(Reference reference) {
        PatientResultSet set = (PatientResultSet)this.createResultSet(null);
        set.setReferenceConstraint(reference);
        return set.hasNext();
    }

    @Override
    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        String patientWildcard = this.getWildcardedText((TextComponent)this.getPatient());
        String contactWildcard = this.getWildcardedText((TextComponent)this.getContact(), true);
        return new PatientResultSet(this.getArchetypeConstraint(), patientWildcard, this.isIdentitySearch(), this.getCustomer(), this.getValue(), contactWildcard, this.getConstraints(), sort, this.getMaxResults());
    }
}

