/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.List;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.edit.AbstractSelectorPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.InMemoryQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class SelectorLookupPropertyEditor
extends AbstractSelectorPropertyEditor<Lookup>
implements LookupPropertyEditor {
    private final String archetype;
    private final IMObject parent;

    public SelectorLookupPropertyEditor(String archetype, Property property, IMObject parent, LayoutContext context) {
        super(property, context);
        this.archetype = archetype;
        this.parent = parent;
        this.updateSelector();
    }

    @Override
    public Lookup getObject() {
        Property property = this.getProperty();
        if (property.isCollection()) {
            List<?> values = ((CollectionProperty)property).getValues();
            return !values.isEmpty() ? (Lookup)values.get(0) : null;
        }
        return ServiceHelper.getLookupService().getLookup(this.parent, property.getName());
    }

    @Override
    public void refresh() {
    }

    @Override
    protected AbstractQuerySelector<Lookup> createSelector(Property property, LayoutContext context, boolean allowCreate) {
        return new LookupSelector(property, allowCreate, context);
    }

    protected List<Lookup> getLookups(Property property) {
        NodeLookupQuery nodeLookupQuery = new NodeLookupQuery(this.parent, property);
        return nodeLookupQuery.getLookups();
    }

    @Override
    protected boolean updateProperty(Property property, Lookup lookup) {
        boolean modified = false;
        if (!property.isCollection()) {
            String value = lookup != null ? lookup.getCode() : null;
            modified = property.setValue(value);
        } else {
            CollectionProperty collection = (CollectionProperty)property;
            List<?> values = collection.getValues();
            if (lookup == null) {
                if (!values.isEmpty()) {
                    for (Object value : values) {
                        collection.remove(value);
                    }
                    modified = true;
                }
            } else if (!values.contains(lookup)) {
                for (Object value : values) {
                    collection.remove(value);
                }
                collection.add(lookup);
                modified = true;
            }
        }
        return modified;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = false;
        AbstractQuerySelector selector = this.getSelector();
        if (!selector.inSelect()) {
            if (!selector.isValid()) {
                Property property = this.getProperty();
                String message = Messages.format((String)"property.error.invalidvalue", (Object[])new Object[]{selector.getText(), property.getDisplayName()});
                validator.add((Modifiable)this, new ValidatorError(property, message));
            } else {
                result = super.doValidation(validator);
            }
        }
        return result;
    }

    protected Query<Lookup> createLookupQuery(String archetype, List<Lookup> lookups) {
        return new LookupInMemoryQuery(archetype, lookups);
    }

    protected static class LookupInMemoryQuery
    extends InMemoryQuery<Lookup> {
        public LookupInMemoryQuery(String archetype, List<Lookup> lookups) {
            super(archetype, Lookup.class, lookups);
            this.setAuto(true);
            this.setDefaultSortConstraint(new SortConstraint[]{new NodeSortConstraint("name"), new NodeSortConstraint("id")});
        }

        @Override
        protected boolean matches(Lookup object, String value) {
            return value == null || this.contains(object.getName(), value);
        }
    }

    protected class LookupSelector
    extends IMObjectSelector<Lookup> {
        private final Property property;

        public LookupSelector(Property property, boolean allowCreate, LayoutContext context) {
            super(property, allowCreate, context);
            this.property = property;
        }

        @Override
        protected void onTextChanged() {
            SelectorLookupPropertyEditor.this.resetValid();
            super.onTextChanged();
        }

        @Override
        protected Query<Lookup> createQuery(String value) {
            List<Lookup> lookups = SelectorLookupPropertyEditor.this.getLookups(this.property);
            Query<Lookup> query = SelectorLookupPropertyEditor.this.createLookupQuery(SelectorLookupPropertyEditor.this.archetype, lookups);
            query.setValue(value);
            return query;
        }
    }
}

