/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.lang.reflect.InvocationTargetException;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.business.service.archetype.helper.lookup.RemoteLookup;
import org.openvpms.component.business.service.archetype.helper.lookup.TargetLookup;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.DefaultLookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupPropertyEditorFactory {
    private static ArchetypeHandlers<LookupPropertyEditor> editors;
    private static final Logger log;

    private LookupPropertyEditorFactory() {
    }

    public static LookupPropertyEditor create(Property property, IMObject parent, LayoutContext context) {
        LookupPropertyEditor result = null;
        ArchetypeHandler handler = null;
        String shortName = null;
        if (property.getDescriptor() != null) {
            LookupAssertion assertion = LookupAssertionFactory.create((NodeDescriptor)property.getDescriptor(), (ArchetypeService)ServiceHelper.getArchetypeService(), (LookupService)ServiceHelper.getLookupService());
            if (assertion instanceof RemoteLookup) {
                shortName = ((RemoteLookup)assertion).getShortName();
                handler = LookupPropertyEditorFactory.getEditors().getHandler(shortName);
            } else if (assertion instanceof TargetLookup) {
                handler = LookupPropertyEditorFactory.getEditors().getHandler(((TargetLookup)assertion).getArchetypes());
            }
        }
        if (handler != null) {
            try {
                if (shortName != null) {
                    try {
                        result = (LookupPropertyEditor)handler.create(new Object[]{shortName, property, parent, context});
                    }
                    catch (NoSuchMethodException ignore) {
                        result = LookupPropertyEditorFactory.create(handler, property, parent, context);
                    }
                } else {
                    result = LookupPropertyEditorFactory.create(handler, property, parent, context);
                }
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
        }
        if (result == null) {
            result = new DefaultLookupPropertyEditor(property, parent);
        }
        return result;
    }

    private static LookupPropertyEditor create(ArchetypeHandler<LookupPropertyEditor> handler, Property property, IMObject parent, LayoutContext context) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        LookupPropertyEditor result;
        try {
            result = (LookupPropertyEditor)handler.create(new Object[]{property, parent, context});
        }
        catch (NoSuchMethodException ignore2) {
            result = (LookupPropertyEditor)handler.create(new Object[]{property, parent});
        }
        return result;
    }

    private static synchronized ArchetypeHandlers<LookupPropertyEditor> getEditors() {
        if (editors == null) {
            editors = new ArchetypeHandlers("LookupPropertyEditorFactory.properties", LookupPropertyEditor.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return editors;
    }

    static {
        log = LoggerFactory.getLogger(LookupPropertyEditorFactory.class);
    }
}

