/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundComboBox;
import org.openvpms.web.component.bound.ComboBoxBinder;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.lookup.StyledLookupListCellRenderer;
import org.openvpms.web.component.property.Property;

public class BoundLookupComboBox
extends BoundComboBox<Lookup> {
    private final LookupQuery lookups;

    public BoundLookupComboBox(Property property, IMObject parent) {
        this(property, new NodeLookupQuery(parent, property));
    }

    public BoundLookupComboBox(Property property, LookupQuery lookups) {
        super(property, (ListModel)new LookupListModel(lookups));
        this.lookups = lookups;
        this.setListCellRenderer(new StyledLookupListCellRenderer());
        this.setListRowCount(10);
        this.getBinder().bind();
        if (this.getSelected() == null && this.getText() == null) {
            this.setDefaultSelection();
        }
    }

    @Override
    public Lookup getSelected() {
        return this.getSelected(this.lookups.getLookups());
    }

    public String getSelectedCode() {
        Lookup result = this.getSelected();
        return result != null ? result.getCode() : null;
    }

    @Override
    public void setSelected(Lookup lookup) {
        this.setSelected(lookup != null ? lookup.getCode() : null);
    }

    @Override
    public void setSelected(String code) {
        this.getProperty().setValue(code);
    }

    public boolean refresh() {
        LookupListModel model = this.getListModel();
        boolean refreshed = model.refresh();
        if (refreshed) {
            this.setDefaultSelection();
        }
        return refreshed;
    }

    public LookupListModel getListModel() {
        return (LookupListModel)super.getListModel();
    }

    @Override
    public LookupListCellRenderer getListCellRenderer() {
        return (LookupListCellRenderer)super.getListCellRenderer();
    }

    @Override
    public void setDefaultSelection() {
        Property property = this.getProperty();
        LookupListModel model = this.getListModel();
        Lookup lookup = model.getDefaultLookup();
        if (lookup != null) {
            this.setSelected(lookup);
        } else if (model.getAllIndex() != -1) {
            property.setValue(null);
            this.setText(this.getText(model.getAllIndex(), model));
        } else if (model.getNoneIndex() != -1) {
            property.setValue(null);
            this.setText(this.getText(model.getNoneIndex(), model));
        } else {
            super.setDefaultSelection();
        }
    }

    @Override
    protected Binder createBinder(Property property) {
        return new ComboBoxBinder(property, this, false){

            @Override
            protected String getObject(String text) {
                Lookup object = (Lookup)BoundLookupComboBox.this.getObject(StringUtils.trimToNull((String)text), BoundLookupComboBox.this.lookups.getLookups());
                return object != null ? object.getCode() : null;
            }

            @Override
            protected String getText(Object value) {
                Lookup lookup;
                String result = null;
                if (value instanceof String && (lookup = BoundLookupComboBox.this.getLookup((String)value)) != null) {
                    result = lookup.getName();
                }
                return result;
            }
        };
    }

    @Override
    protected boolean isPlaceholder(String text) {
        return this.isPlaceholder(text, this.getListModel());
    }

    protected LookupQuery getLookups() {
        return this.lookups;
    }

    private Lookup getLookup(String code) {
        for (Lookup lookup : this.lookups.getLookups()) {
            if (!code.equals(lookup.getCode())) continue;
            return lookup;
        }
        return null;
    }
}

