/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.list;

import nextapp.echo2.app.Component;
import org.openvpms.web.component.im.list.BoldListCell;
import org.openvpms.web.component.im.list.TextListCellRenderer;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractListCellRenderer<T>
implements TextListCellRenderer {
    private final Class<T> type;
    private final String ALL = Messages.get((String)"list.all");
    private final String NONE = Messages.get((String)"list.none");
    private final String DEFAULT = Messages.get((String)"list.default");

    public AbstractListCellRenderer(Class<T> type) {
        this.type = type;
    }

    public Object getListCellRendererComponent(Component list, Object value, int index) {
        Object result = null;
        if (value == null || this.type.isAssignableFrom(value.getClass())) {
            T object = this.type.cast(value);
            result = this.isAll(list, object, index) ? new BoldListCell(this.getAll()) : (this.isNone(list, object, index) ? new BoldListCell(this.getNone()) : (this.isDefault(list, object, index) ? new BoldListCell(this.getDefault()) : this.getComponent(list, object, index)));
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getText(Component list, Object value, int index) {
        String result = null;
        if (value == null || this.type.isAssignableFrom(value.getClass())) {
            T object = this.type.cast(value);
            result = this.isAll(list, object, index) ? this.getAll() : (this.isNone(list, object, index) ? this.getNone() : (this.isDefault(list, object, index) ? this.getDefault() : this.toString(list, object, index)));
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    protected String getAll() {
        return this.ALL;
    }

    protected String getNone() {
        return this.NONE;
    }

    protected String getDefault() {
        return this.DEFAULT;
    }

    protected Object getComponent(Component list, T object, int index) {
        return this.toString(list, object, index);
    }

    protected abstract String toString(Component var1, T var2, int var3);

    protected abstract boolean isAll(Component var1, T var2, int var3);

    protected abstract boolean isNone(Component var1, T var2, int var3);

    protected boolean isDefault(Component list, T object, int index) {
        return false;
    }
}

