/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.BoundColorSelect;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.colour.ColourHelper;

public class ColourNodeLayoutStrategy
extends AbstractLayoutStrategy {
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        this.addColour(object, properties, context);
        return super.apply(object, properties, parent, context);
    }

    protected void addColour(IMObject object, PropertySet properties, LayoutContext context) {
        Property property = properties.get("colour");
        if (property != null) {
            ComponentState state;
            if (context.isEdit()) {
                BoundColorSelect component = new BoundColorSelect(property);
                state = new ComponentState((Component)component, property);
            } else {
                state = this.createComponent(property, object, context);
                String value = (String)property.getValue();
                if (value != null) {
                    Color color = ColourHelper.getColor((String)value);
                    state.getComponent().setBackground(color);
                }
            }
            this.addComponent(state);
        }
    }
}

