/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.archetype.Units;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.audit.AuditInfo;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectTabPane;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.layout.LayoutHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractLayoutStrategy
implements IMObjectLayoutStrategy {
    public static ArchetypeNodes DEFAULT_NODES = new ImmutableArchetypeNodes();
    private final Map<String, ComponentState> states = new HashMap<String, ComponentState>();
    private final boolean keepState;
    private ArchetypeNodes nodes;
    private ComponentSet components;
    private FocusGroup focusGroup;
    private boolean inApply;

    public AbstractLayoutStrategy() {
        this(false);
    }

    public AbstractLayoutStrategy(boolean keepState) {
        this(DEFAULT_NODES, keepState);
    }

    public AbstractLayoutStrategy(ArchetypeNodes nodes) {
        this(nodes, false);
    }

    public AbstractLayoutStrategy(ArchetypeNodes nodes, boolean keepState) {
        this.nodes = nodes;
        this.keepState = keepState;
    }

    @Override
    public void addComponent(ComponentState state) {
        Property property = state.getProperty();
        if (property == null) {
            throw new IllegalArgumentException("Argument 'state' must be associated with a property");
        }
        this.states.put(property.getName(), state);
    }

    public void removeComponent(String name) {
        this.states.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState state;
        if (this.inApply) {
            throw new IllegalStateException("Cannot call apply() recursively");
        }
        this.inApply = true;
        try {
            this.focusGroup = new FocusGroup(DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.getService()));
            this.components = new ComponentSet(this.focusGroup);
            Component container = this.doLayout(object, properties, parent, context);
            this.focusGroup.setDefault(this.getDefaultFocus());
            state = new ComponentState(container, this.focusGroup);
            this.components = null;
            if (!this.keepState) {
                this.focusGroup = null;
            }
        }
        finally {
            this.inApply = false;
        }
        return state;
    }

    protected FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected Component doLayout(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Column container = ColumnFactory.create((String)"CellSpacing");
        this.doLayout(object, properties, parent, (Component)container, context);
        return container;
    }

    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        ArchetypeDescriptor archetype = context.getArchetypeDescriptor(object);
        ArchetypeNodes nodes = this.getArchetypeNodes(object, context);
        NodeFilter filter = this.getNodeFilter(object, context);
        List<Property> simple = nodes.getSimpleNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List<Property> complex = nodes.getComplexNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        this.doSimpleLayout(object, parent, simple, container, context);
        this.doComplexLayout(object, parent, complex, container, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (!properties.isEmpty()) {
            ComponentGrid grid = this.createGrid(object, properties, context);
            this.addAuditInfo(object, grid, context);
            Grid component = this.createGrid(grid);
            container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
        }
    }

    protected void addAuditInfo(IMObject object, ComponentGrid grid, LayoutContext context) {
        if (object instanceof AuditableIMObject) {
            AuditInfo info = new AuditInfo((AuditableIMObject)object, context.getNames());
            grid.set(0, grid.getColumns(0) + 1, (Component)RowFactory.create((Component[])new Component[]{info}));
        }
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        int columns = this.getColumns(properties);
        return this.createGrid(object, properties, context, columns);
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context, int columns) {
        ComponentSet set = this.createComponentSet(object, properties, context);
        ComponentGrid grid = new ComponentGrid();
        grid.add(set, columns);
        return grid;
    }

    protected Grid createGrid(ComponentGrid grid) {
        return grid.createGrid(this.components);
    }

    protected int getColumns(List<Property> properties) {
        return properties.size() <= 4 ? 1 : 2;
    }

    protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (!properties.isEmpty()) {
            IMObjectTabPaneModel model = this.doTabLayout(object, properties, container, context, false);
            IMObjectTabPane pane = new IMObjectTabPane(model);
            pane.setSelectedIndex(0);
            pane.validate();
            container.add((Component)pane);
        }
    }

    protected ArchetypeNodes getArchetypeNodes(IMObject object, LayoutContext context) {
        return this.getArchetypeNodes();
    }

    protected void setArchetypeNodes(ArchetypeNodes nodes) {
        this.nodes = nodes;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }

    protected NodeFilter getNodeFilter(IMObject object, LayoutContext context) {
        return context.getDefaultNodeFilter();
    }

    protected void doGridLayout(ComponentGrid grid, Component container) {
        Grid g = grid.createGrid(this.components);
        container.add((Component)g);
    }

    protected IMObjectTabPaneModel doTabLayout(IMObject object, List<Property> properties, Component container, LayoutContext context, boolean shortcutHint) {
        IMObjectTabPaneModel model;
        boolean shortcuts = false;
        if (context.getLayoutDepth() == 0 && (properties.size() > 1 || shortcutHint)) {
            model = this.createTabModel(container);
            shortcuts = true;
        } else {
            model = this.createTabModel(null);
        }
        this.doTabLayout(object, properties, model, context, shortcuts);
        return model;
    }

    protected IMObjectTabPaneModel createTabModel(Component container) {
        return new IMObjectTabPaneModel(container);
    }

    protected void doTabLayout(IMObject object, List<Property> properties, IMObjectTabPaneModel model, LayoutContext context, boolean shortcuts) {
        for (Property property : properties) {
            ComponentState child = this.createComponent(property, object, context);
            this.addTab(model, property, child, shortcuts);
        }
    }

    protected void addTab(IMObjectTabPaneModel model, Property property, ComponentState component, boolean addShortcut) {
        Component child;
        this.setFocusTraversal(component);
        String text = component.getDisplayName();
        if (text == null) {
            text = property.getDisplayName();
        }
        if (addShortcut && model.size() < 10) {
            text = this.getShortcut(text, model.size() + 1);
        }
        if ((child = component.getComponent()) instanceof SelectField) {
            child = RowFactory.create((Component[])new Component[]{child});
        }
        if (LayoutHelper.needsInset(child)) {
            child = ColumnFactory.create((String)"Inset", (Component[])new Component[]{child});
        }
        model.addTab(property, text, child);
    }

    protected void addTab(String label, IMObjectTabPaneModel model, Component component) {
        if (model.size() < 10) {
            label = this.getShortcut(label, model.size() + 1);
        }
        model.addTab(label, component);
    }

    protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentSet result = new ComponentSet();
        return this.addComponents(result, object, properties, context);
    }

    protected ComponentSet addComponents(ComponentSet set, IMObject object, Collection<Property> properties, LayoutContext context) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        for (Property property : properties) {
            map.put(property.getName(), property);
        }
        LinkedHashMap<String, Property> unitNodes = new LinkedHashMap<String, Property>();
        for (Property property : properties) {
            Property unitProperty;
            Units units = property.getUnits();
            if (units == null || units.getNode() == null || (unitProperty = (Property)map.remove(units.getNode())) == null) continue;
            unitNodes.put(unitProperty.getName(), unitProperty);
        }
        for (Property property : map.values()) {
            ComponentState component = this.createComponent(property, object, context);
            Units units = property.getUnits();
            if (units != null) {
                if (units.getNode() != null) {
                    Property unitProperty = (Property)unitNodes.remove(units.getNode());
                    if (unitProperty != null) {
                        ComponentState unitComponent = this.createComponent(unitProperty, object, context);
                        component = this.createComponentPair(component, unitComponent);
                    }
                } else if (units.getDisplayName() != null) {
                    component = new ComponentState((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{component.getComponent(), LabelFactory.text((String)units.getDisplayName())}), property, component.getFocusGroup());
                }
            }
            set.add(component);
        }
        return set;
    }

    protected void add(ComponentGrid grid, String name, Component component) {
        Label label = LabelFactory.create();
        if (name != null) {
            label.setText(name);
        }
        grid.add(new Component[]{label, component});
    }

    protected void add(Component container, String name, Component component) {
        Label label = LabelFactory.create();
        if (name != null) {
            label.setText(name);
        }
        this.add(container, label, component);
    }

    protected void add(Component container, Label label, Component component) {
        container.add((Component)label);
        container.add(component);
    }

    protected void add(Component container, String name, ComponentState component) {
        this.add(container, name, component.getComponent());
        this.setFocusTraversal(component);
    }

    protected void add(Component container, ComponentState component) {
        Property property = component.getProperty();
        String name = null;
        if (property != null) {
            name = property.getDisplayName();
        }
        this.add(container, name, component);
        this.setFocusTraversal(component);
    }

    protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
        ComponentState result = this.getComponent(property);
        if (result == null) {
            IMObjectComponentFactory factory = context.getComponentFactory();
            result = factory.create(property, parent);
        }
        return result;
    }

    protected ComponentState getComponent(Property property) {
        return this.getComponent(property.getName());
    }

    protected ComponentState getComponent(String name) {
        return this.states.get(name);
    }

    protected Component getDefaultFocus() {
        return this.getDefaultFocus(this.components);
    }

    protected Component getDefaultFocus(ComponentSet components) {
        return components.getFocusable();
    }

    protected void setFocusTraversal(ComponentState state) {
        if (this.components != null) {
            this.components.setFocusTraversal(state);
        }
    }

    protected String getShortcut(String name, int shortcut) {
        if (shortcut == 10) {
            shortcut = 0;
        }
        return "&" + shortcut + " " + name;
    }

    protected Property createReadOnly(Property property) {
        return new ReadOnlyProperty(property);
    }

    protected ComponentState createComponentPair(String name1, String name2, IMObject object, PropertySet properties, LayoutContext context) {
        return this.createComponentPair(properties.get(name1), properties.get(name2), object, context);
    }

    protected ComponentState createComponentPair(Property property1, Property property2, IMObject object, LayoutContext context) {
        ComponentState state1 = this.createComponent(property1, object, context);
        ComponentState state2 = this.createComponent(property2, object, context);
        return this.createComponentPair(state1, state2);
    }

    protected ComponentState createComponentPair(ComponentState state1, ComponentState state2) {
        Property property = state1.getProperty();
        FocusGroup group = new FocusGroup(property.getName());
        group.add(state1.getComponent());
        group.add(state2.getComponent());
        return new ComponentState((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{state1.getComponent(), state2.getComponent()}), property, group);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getService().getBean(object);
    }

    protected String getDisplayName(IMObject object) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(String archetype) {
        String displayName = DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.getService());
        return displayName != null ? displayName : archetype;
    }

    protected String getDisplayName(String archetype, String node) {
        String displayName = DescriptorHelper.getDisplayName((String)archetype, (String)node, (ArchetypeService)this.getService());
        return displayName != null ? displayName : node;
    }

    protected IArchetypeRuleService getService() {
        return ServiceHelper.getArchetypeService();
    }

    protected ComponentState createComponent(Property property, Extent width, Extent height, IMObject parent, LayoutContext context) {
        ComponentState state = this.createComponent(property, parent, context);
        Component component = state.getComponent();
        if (component instanceof TextArea) {
            TextArea textArea = (TextArea)component;
            if (width != null) {
                textArea.setWidth(width);
            }
            if (height != null) {
                textArea.setHeight(height);
            }
        }
        return state;
    }

    protected ComponentState createMultiLineText(Property property, int minLines, int maxLines, Extent width, LayoutContext context) {
        Hint hint = this.getTextHint(property, minLines, maxLines, width);
        Component result = context.getComponentFactory().create(property, hint);
        return new ComponentState(result, property);
    }

    protected ComponentState createMultiLineText(Property property, IMObject object, int minLines, int maxLines, Extent width, LayoutContext context) {
        Hint hint = this.getTextHint(property, minLines, maxLines, width);
        return context.getComponentFactory().create(property, object, hint);
    }

    protected int getLines(Property property) {
        int result = 0;
        String value = property.getString();
        if (!StringUtils.isEmpty((CharSequence)value)) {
            result = StringUtils.countMatches((CharSequence)value, (CharSequence)"\n");
            result = Math.max(value.length() / 80, result);
            ++result;
        }
        return Math.max(result, 1);
    }

    private Hint getTextHint(Property property, int minLines, int maxLines, Extent width) {
        int lines = this.getLines(property);
        if (lines < minLines) {
            lines = minLines;
        } else if (lines > maxLines) {
            lines = maxLines;
        }
        Hint hint = lines == 1 && property.isReadOnly() ? (width == null ? Hint.height(1) : Hint.newHint().width(width).height(1).build()) : Hint.newHint().height(lines + 1).width(width).build();
        return hint;
    }

    private static class ImmutableArchetypeNodes
    extends ArchetypeNodes {
        private ImmutableArchetypeNodes() {
        }

        @Override
        public ArchetypeNodes first(String first) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes second(String second) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes simple(String ... nodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes complex(String ... nodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes exclude(String ... nodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes exclude(Collection<String> nodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes excludeIfEmpty(String ... nodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes excludeStringLongerThan(long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchetypeNodes excludePassword(boolean exclude) {
            return super.excludePassword(exclude);
        }

        @Override
        public ArchetypeNodes hidden(boolean hidden) {
            return super.hidden(hidden);
        }

        @Override
        public ArchetypeNodes order(String node1, String node2) {
            throw new UnsupportedOperationException();
        }
    }
}

