/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.HashSet;
import java.util.Set;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.delete.DefaultIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.filter.BasicNodeFilter;
import org.openvpms.web.component.im.filter.ChainedNodeFilter;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.filter.ValueNodeFilter;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.layout.ViewLayoutStrategyFactory;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractLayoutContext
implements LayoutContext {
    private final Context context;
    private final HelpContext help;
    private final Set<Reference> rendered = new HashSet<Reference>();
    private final Preferences preferences;
    private LayoutContext parent;
    private IMObjectCache cache;
    private IMObjectNames names;
    private boolean edit;
    private IMObjectEditorFactory editorFactory;
    private IMObjectComponentFactory factory;
    private NodeFilter filter;
    private IMObjectLayoutStrategyFactory layoutFactory;
    private int depth;
    private IMObjectDeletionListener<IMObject> deletionListener = DEFAULT_DELETION_LISTENER;
    private MailContext mailContext;
    private ContextSwitchListener contextSwitchListener;
    private Variables variables;
    private static final IMObjectDeletionListener<IMObject> DEFAULT_DELETION_LISTENER = new DefaultIMObjectDeletionListener<IMObject>();

    public AbstractLayoutContext(Context context, HelpContext help) {
        this(null, context, help);
    }

    public AbstractLayoutContext(boolean edit, Context context, HelpContext help) {
        this(null, context, help);
        this.edit = edit;
    }

    public AbstractLayoutContext(IMObjectComponentFactory factory, Context context, HelpContext help) {
        this.factory = factory;
        this.context = context;
        this.help = help;
        ValueNodeFilter id = new ValueNodeFilter("id", -1);
        BasicNodeFilter showOptional = new BasicNodeFilter(true);
        this.filter = new ChainedNodeFilter(id, showOptional);
        this.editorFactory = ServiceHelper.getBean(IMObjectEditorFactory.class);
        this.layoutFactory = ServiceHelper.getBean(ViewLayoutStrategyFactory.class);
        this.preferences = ServiceHelper.getPreferences();
    }

    public AbstractLayoutContext(LayoutContext context) {
        this(context, context.getHelpContext());
    }

    public AbstractLayoutContext(LayoutContext context, HelpContext help) {
        this.parent = context;
        this.context = context.getContext();
        this.cache = context.getCache();
        this.names = context.getNames();
        this.factory = context.getComponentFactory();
        this.editorFactory = context.getEditorFactory();
        this.filter = context.getDefaultNodeFilter();
        this.edit = context.isEdit();
        this.layoutFactory = context.getLayoutStrategyFactory();
        this.depth = context.getLayoutDepth() + 1;
        this.deletionListener = context.getDeletionListener();
        this.mailContext = context.getMailContext();
        this.contextSwitchListener = context.getContextSwitchListener();
        this.help = help;
        this.preferences = context.getPreferences();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public IMObjectCache getCache() {
        if (this.cache == null) {
            this.cache = new SoftRefIMObjectCache((ArchetypeService)ServiceHelper.getArchetypeService());
        }
        return this.cache;
    }

    @Override
    public void setCache(IMObjectCache cache) {
        this.cache = cache;
    }

    @Override
    public IMObjectNames getNames() {
        if (this.names == null) {
            this.names = new IMObjectNames(this.getCache(), (IArchetypeService)ServiceHelper.getArchetypeService(), 100);
        }
        return this.names;
    }

    @Override
    public boolean isEdit() {
        return this.edit;
    }

    @Override
    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    @Override
    public IMObjectComponentFactory getComponentFactory() {
        return this.factory;
    }

    @Override
    public void setComponentFactory(IMObjectComponentFactory factory) {
        this.factory = factory;
    }

    @Override
    public NodeFilter getDefaultNodeFilter() {
        return this.filter;
    }

    @Override
    public void setNodeFilter(NodeFilter filter) {
        this.filter = filter;
    }

    @Override
    public IMObjectEditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(IMObjectEditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }

    @Override
    public IMObjectLayoutStrategyFactory getLayoutStrategyFactory() {
        return this.layoutFactory;
    }

    @Override
    public void setLayoutStrategyFactory(IMObjectLayoutStrategyFactory factory) {
        this.layoutFactory = factory;
    }

    @Override
    public int getLayoutDepth() {
        return this.depth;
    }

    @Override
    public void setLayoutDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public void setRendered(IMObject object) {
        this.rendered.add(object.getObjectReference());
    }

    @Override
    public boolean isRendered(IMObject object) {
        return this.isRendered(object.getObjectReference());
    }

    @Override
    public boolean isRendered(Reference object) {
        boolean result = this.rendered.contains(object);
        if (!result && this.parent != null) {
            result = this.parent.isRendered(object);
        }
        return result;
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(IMObject object) {
        ArchetypeDescriptor result = null;
        if (this.parent != null) {
            result = this.parent.getArchetypeDescriptor(object);
        }
        if (result == null && (result = DescriptorHelper.getArchetypeDescriptor((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService())) == null) {
            throw new IllegalStateException("No archetype descriptor found for object, id=" + object.getId() + ", archetype=" + object.getArchetype());
        }
        return result;
    }

    @Override
    public void setDeletionListener(IMObjectDeletionListener<IMObject> listener) {
        this.deletionListener = listener != null ? listener : DEFAULT_DELETION_LISTENER;
    }

    @Override
    public IMObjectDeletionListener<IMObject> getDeletionListener() {
        return this.deletionListener;
    }

    @Override
    public void setMailContext(MailContext context) {
        this.mailContext = context;
    }

    @Override
    public MailContext getMailContext() {
        return this.mailContext;
    }

    @Override
    public void setContextSwitchListener(ContextSwitchListener listener) {
        this.contextSwitchListener = listener;
    }

    @Override
    public ContextSwitchListener getContextSwitchListener() {
        return this.contextSwitchListener;
    }

    @Override
    public HelpContext getHelpContext() {
        return this.help;
    }

    @Override
    public Variables getVariables() {
        if (this.variables == null) {
            this.variables = new MacroVariables(this.getContext(), (ArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
        }
        return this.variables;
    }

    @Override
    public Preferences getPreferences() {
        return this.preferences;
    }
}

