/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.filter;

import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.NodeFilter;

public class NamedNodeFilter
implements NodeFilter {
    private final String[] names;
    private final boolean exclude;

    public NamedNodeFilter(String ... names) {
        this(true, names);
    }

    public NamedNodeFilter(boolean exclude, String ... names) {
        this.exclude = exclude;
        this.names = names;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamedNodeFilter)) {
            return false;
        }
        NamedNodeFilter other = (NamedNodeFilter)obj;
        if (this.names.length != other.names.length) {
            return false;
        }
        for (String name : this.names) {
            if (ArrayUtils.contains((Object[])other.names, (Object)name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean include(NodeDescriptor descriptor, IMObject object) {
        boolean result = this.exclude;
        for (String name : this.names) {
            if (!name.equals(descriptor.getName())) continue;
            result = !this.exclude;
            break;
        }
        return result;
    }

    public static NamedNodeFilter include(String ... names) {
        return new NamedNodeFilter(false, names);
    }

    public static NamedNodeFilter exclude(String ... names) {
        return new NamedNodeFilter(names);
    }
}

