/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.filter;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.ChainedNodeFilter;
import org.openvpms.web.component.im.filter.NodeFilter;

public final class FilterHelper {
    private FilterHelper() {
    }

    public static List<NodeDescriptor> filter(IMObject object, NodeFilter filter, ArchetypeDescriptor descriptor) {
        List<NodeDescriptor> simple = FilterHelper.filter(object, filter, descriptor.getSimpleNodeDescriptors());
        List<NodeDescriptor> complex = FilterHelper.filter(object, filter, descriptor.getComplexNodeDescriptors());
        ArrayList<NodeDescriptor> filtered = new ArrayList<NodeDescriptor>(simple);
        filtered.addAll(complex);
        return filtered;
    }

    public static List<NodeDescriptor> filter(IMObject object, NodeFilter filter, List<NodeDescriptor> descriptors) {
        ArrayList<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        if (filter == null) {
            result.addAll(descriptors);
        } else {
            for (NodeDescriptor descriptor : descriptors) {
                if (!filter.include(descriptor, object)) continue;
                result.add(descriptor);
            }
        }
        return result;
    }

    public static ChainedNodeFilter chain(NodeFilter ... filters) {
        ChainedNodeFilter result = new ChainedNodeFilter();
        for (NodeFilter filter : filters) {
            if (filter == null) continue;
            result.add(filter);
        }
        return result;
    }
}

