/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.function.list.ListFunctions;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductTemplateExpander {
    private final boolean useLocationProducts;
    private final Party location;
    private final Party stockLocation;
    private final StockRules stockRules;
    private final ProductRules productRules;
    private final IArchetypeRuleService service;

    public ProductTemplateExpander() {
        this(false, null, null);
    }

    public ProductTemplateExpander(boolean useLocationProducts, Party location, Party stockLocation) {
        this.useLocationProducts = useLocationProducts;
        this.location = location;
        this.stockLocation = stockLocation;
        this.stockRules = ServiceHelper.getBean(StockRules.class);
        this.productRules = ServiceHelper.getBean(ProductRules.class);
        this.service = ServiceHelper.getArchetypeService();
    }

    public Collection<TemplateProduct> expand(Product template, Weight weight, BigDecimal quantity, IMObjectCache cache) {
        LinkedHashMap<TemplateProduct, TemplateProduct> includes = new LinkedHashMap<TemplateProduct, TemplateProduct>();
        ArrayDeque<Product> parents = new ArrayDeque<Product>();
        if (!this.expand(template, template, weight, includes, quantity, quantity, false, parents, cache)) {
            includes.clear();
        } else if (includes.isEmpty()) {
            this.reportNoExpansion(template, weight);
        }
        return includes.values();
    }

    protected boolean expand(Product root, Product template, Weight weight, Map<TemplateProduct, TemplateProduct> includes, BigDecimal lowQuantity, BigDecimal highQuantity, boolean zeroPrice, Deque<Product> parents, IMObjectCache cache) {
        boolean result = true;
        if (template.isActive()) {
            if (!parents.contains(template)) {
                parents.push(template);
                IMObjectBean bean = this.service.getBean((IMObject)template);
                List links = bean.getValues("includes", EntityLink.class);
                links.sort(Comparator.comparingInt(SequencedRelationship::getSequence));
                for (EntityLink relationship : links) {
                    if (this.include(relationship, root, template, weight, includes, lowQuantity, highQuantity, zeroPrice, parents, cache)) continue;
                    result = false;
                    break;
                }
                parents.pop();
            } else {
                this.reportRecursionError(root, template, parents);
                result = false;
            }
        }
        return result;
    }

    protected boolean include(EntityLink relationship, Product root, Product template, Weight weight, Map<TemplateProduct, TemplateProduct> includes, BigDecimal lowQuantity, BigDecimal highQuantity, boolean zeroPrice, Deque<Product> parents, IMObjectCache cache) {
        Product product;
        boolean result = true;
        Include include = new Include((Relationship)relationship, (IArchetypeService)this.service);
        if (include.requiresWeight() && weight.isZero()) {
            this.reportWeightError(template, relationship);
            result = false;
        } else if (include.isIncluded(weight) && (product = include.getProduct(cache)) != null && product.isActive()) {
            Party location;
            boolean skip = false;
            if (this.useLocationProducts && (location = this.checkProductLocation(product)) != null) {
                if (!include.skipIfMissing()) {
                    this.reportLocationError(template, product, location);
                    result = false;
                } else {
                    skip = true;
                }
            }
            if (!skip) {
                boolean zero;
                BigDecimal newLowQty = include.lowQuantity.multiply(lowQuantity);
                BigDecimal newHighQty = include.highQuantity.multiply(highQuantity);
                boolean bl = zero = include.zeroPrice || zeroPrice;
                if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
                    if (!this.expand(root, product, weight, includes, newLowQty, newHighQty, zero, parents, cache)) {
                        result = false;
                    }
                } else {
                    TemplateProduct included = new TemplateProduct(product, newLowQty, newHighQty, zero, include.print);
                    TemplateProduct existing = includes.get(included);
                    if (existing == null) {
                        includes.put(included, included);
                    } else {
                        existing.add(newLowQty, newHighQty);
                    }
                }
            }
        }
        return result;
    }

    protected void reportWeightError(Product template, EntityLink relationship) {
        String message = Messages.format((String)"product.template.weightrequired", (Object[])new Object[]{template.getName(), IMObjectHelper.getName(relationship.getTarget())});
        ErrorDialog.show((String)message);
    }

    protected void reportRecursionError(Product root, Product template, Deque<Product> parents) {
        ListFunctions functions = new ListFunctions((IArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
        ArrayList<Product> products = new ArrayList<Product>(parents);
        Collections.reverse(products);
        products.add(template);
        String names = functions.names(products, Messages.get((String)"product.template.includes"));
        String message = Messages.format((String)"product.template.recursion", (Object[])new Object[]{root.getName(), template.getName(), names});
        ErrorDialog.show((String)message);
    }

    protected void reportNoExpansion(Product root, Weight weight) {
        String message = Messages.format((String)"product.template.noproducts", (Object[])new Object[]{root.getName(), weight.getWeight()});
        ErrorDialog.show((String)message);
    }

    protected void reportLocationError(Product template, Product product, Party location) {
        String message = Messages.format((String)"product.template.notatlocation", (Object[])new Object[]{template.getName(), product.getName(), location.getName()});
        ErrorDialog.show((String)message);
    }

    protected Party checkProductLocation(Product product) {
        Party result = null;
        if (TypeHelper.isA((IMObject)product, (String[])new String[]{"product.medication", "product.merchandise"})) {
            if (this.stockLocation != null && !this.stockRules.hasStockRelationship(product, this.stockLocation)) {
                result = this.stockLocation;
            }
        } else if (TypeHelper.isA((IMObject)product, (String[])new String[]{"product.service", "product.template"}) && this.location != null && !this.productRules.canUseProductAtLocation(product, this.location)) {
            result = this.location;
        }
        return result;
    }

    private class Include {
        private final BigDecimal minWeight;
        private final BigDecimal maxWeight;
        private final WeightUnits units;
        private final BigDecimal lowQuantity;
        private final BigDecimal highQuantity;
        private final Reference product;
        private final boolean zeroPrice;
        private final boolean print;
        private final boolean skipIfMissing;

        public Include(Relationship relationship, IArchetypeService service) {
            IMObjectBean bean = service.getBean((IMObject)relationship);
            this.units = WeightUnits.fromString((String)bean.getString("weightUnits"), (WeightUnits)WeightUnits.KILOGRAMS);
            this.minWeight = bean.getBigDecimal("minWeight", BigDecimal.ZERO);
            this.maxWeight = bean.getBigDecimal("maxWeight", BigDecimal.ZERO);
            this.lowQuantity = bean.getBigDecimal("lowQuantity", BigDecimal.ZERO);
            this.highQuantity = bean.getBigDecimal("highQuantity", BigDecimal.ZERO);
            this.zeroPrice = bean.getBoolean("zeroPrice");
            this.print = bean.getBoolean("print", true);
            this.product = relationship.getTarget();
            this.skipIfMissing = bean.getBoolean("skipIfMissing");
        }

        public boolean requiresWeight() {
            return this.minWeight.compareTo(BigDecimal.ZERO) != 0 || this.maxWeight.compareTo(BigDecimal.ZERO) != 0;
        }

        public boolean isIncluded(Weight weight) {
            return !this.requiresWeight() || weight.between(this.minWeight, this.maxWeight, this.units);
        }

        public Product getProduct(IMObjectCache cache) {
            return (Product)cache.get(this.product);
        }

        public boolean skipIfMissing() {
            return this.skipIfMissing;
        }
    }
}

