/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.edit.DefaultCollectionResultSetFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.act.ProductListener;
import org.openvpms.web.component.im.edit.act.ProductTemplateExpander;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.edit.act.TemplateProductListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.MultipleRelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.system.ServiceHelper;

public class ActRelationshipCollectionEditor
extends MultipleRelationshipCollectionTargetEditor {
    private final ProductListener productListener;
    private final Map<Reference, Boolean> modified = new HashMap<Reference, Boolean>();
    private boolean excludeDefaultValueObject = true;
    private TemplateProductListener templateProductListener;

    public ActRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        this(property, act, context, DefaultCollectionResultSetFactory.INSTANCE);
    }

    public ActRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context, CollectionResultSetFactory factory) {
        super(new ActRelationshipCollectionPropertyEditor(property, act, (IMObjects)context.getCache()), (IMObject)act, context, factory);
        this.productListener = this::onProductChanged;
    }

    public void editFirst() {
        List<Act> acts;
        if (this.addCurrentEdits(new DefaultValidator()) && !(acts = this.getCurrentActs()).isEmpty()) {
            Act first = acts.get(0);
            IMObjectEditor currentEditor = this.getCurrentEditor();
            if (currentEditor == null || !currentEditor.getObject().equals(first)) {
                this.setSelected((IMObject)first);
                this.edit((IMObject)first);
            }
        }
    }

    public List<Act> getActs() {
        ActRelationshipCollectionPropertyEditor collection = this.getEditor();
        return new ArrayList<Act>(collection.getActs().keySet());
    }

    public List<Act> getActs(Predicate<Act> predicate) {
        ArrayList result = new ArrayList();
        return (List)CollectionUtils.select(this.getActs(), predicate, result);
    }

    public List<Act> getCurrentActs() {
        LinkedHashSet<Act> result = new LinkedHashSet<Act>(this.getActs());
        IMObjectEditor current = this.getCurrentEditor();
        if (current != null) {
            result.add((Act)current.getObject());
        }
        return new ArrayList<Act>(result);
    }

    public List<Act> getCurrentActs(Predicate<Act> predicate) {
        ArrayList result = new ArrayList();
        return (List)CollectionUtils.select(this.getCurrentActs(), predicate, result);
    }

    public void setTemplateProductListener(TemplateProductListener listener) {
        this.templateProductListener = listener;
    }

    public TemplateProductListener getTemplateProductListener() {
        return this.templateProductListener;
    }

    @Override
    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        IMObjectEditor editor = super.createEditor(object, context);
        if (editor instanceof ActItemEditor) {
            ((ActItemEditor)editor).setProductListener(this.productListener);
        }
        return editor;
    }

    @Override
    public boolean addEdited(IMObjectEditor editor) {
        boolean result = false;
        if (this.needsTemplateExpansion(editor)) {
            Product product = ((ActItemEditor)editor).getProduct();
            if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
                result = this.expandTemplate((ActItemEditor)editor, product, BigDecimal.ONE);
            }
        } else {
            result = super.addEdited(editor);
        }
        return result;
    }

    public void setExcludeDefaultValueObject(boolean exclude) {
        this.excludeDefaultValueObject = exclude;
    }

    public boolean isModified(Act act) {
        Boolean result = this.modified.get(act.getObjectReference());
        return result != null && result != false;
    }

    public void setModified(Act act, boolean modified) {
        this.modified.put(act.getObjectReference(), modified);
    }

    @Override
    public ActRelationshipCollectionPropertyEditor getEditor() {
        return (ActRelationshipCollectionPropertyEditor)this.getCollectionPropertyEditor();
    }

    public boolean expandTemplate(ActItemEditor editor, Product template, BigDecimal quantity) {
        boolean result = false;
        if (template != null) {
            List<Act> items = this.createTemplateActs(editor, template, quantity);
            boolean bl = result = !items.isEmpty();
            if (result && this.templateProductListener != null) {
                this.templateProductListener.expanded(template);
            }
        }
        if (!result) {
            this.setTemplateProduct(editor, null, null, -1);
        } else {
            this.populateTable();
            Act object = editor.getObject();
            this.setSelected((IMObject)object);
        }
        return result;
    }

    public int getNextTemplateGroup() {
        int last = -1;
        for (Act act : this.getCurrentActs()) {
            int group;
            IMObjectBean templateBean;
            IMObjectBean bean = this.getBean((IMObject)act);
            IMObject template = bean.hasNode("template") ? bean.getObject("template", IMObject.class) : null;
            if (!(template instanceof Participation) || !(templateBean = this.getBean(template)).hasNode("group") || (group = templateBean.getInt("group")) <= last) continue;
            last = group;
        }
        return last + 1;
    }

    @Override
    protected boolean addCurrentEdits(Validator validator) {
        boolean valid = true;
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null && (valid = validator.validate(editor))) {
            boolean checkValid = this.needsTemplateExpansion(editor);
            this.addEdited(editor);
            if (checkValid) {
                valid = validator.validate(editor);
            }
        }
        return valid;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean valid = !this.excludeObjectWithDefaultValues() ? super.doValidation(validator) : this.getCollectionPropertyEditor().validate(validator);
        return valid;
    }

    @Override
    protected void doSave() {
        if (!this.excludeObjectWithDefaultValues()) {
            super.doSave();
        } else {
            this.getCollectionPropertyEditor().save();
        }
    }

    @Override
    protected void addEditor(IMObject object, IMObjectEditor editor) {
        super.addEditor(object, editor);
        if (this.modified.get(object.getObjectReference()) == null) {
            this.setModified((Act)object, false);
        }
    }

    @Override
    protected void onCurrentEditorModified() {
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null) {
            Act object = (Act)editor.getObject();
            this.setModified(object, true);
        }
        super.onCurrentEditorModified();
    }

    protected List<Act> createTemplateActs(ActItemEditor editor, Product template, BigDecimal quantity) {
        Act act;
        ArrayList<Act> result = new ArrayList<Act>();
        ActRelationshipCollectionPropertyEditor collection = this.getEditor();
        int group = this.getNextTemplateGroup();
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new ActItemCopyHandler(), (ArchetypeService)ServiceHelper.getArchetypeService());
        Collection<TemplateProduct> includes = this.getProductIncludes(template, editor.getPatient(), quantity);
        Act copy = act = editor.getObject();
        Date startTime = act.getActivityStartTime();
        Context context = this.getContext().getContext();
        User currentClinician = context.getClinician();
        context.setClinician(editor.getClinician());
        for (TemplateProduct include : includes) {
            if (copy == null) {
                List objects = copier.apply((IMObject)act);
                copy = (Act)objects.get(0);
                DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext());
                layoutContext.setComponentFactory(new ReadOnlyComponentFactory(layoutContext));
                editor = (ActItemEditor)this.createEditor((IMObject)copy, layoutContext);
                copy.setActivityStartTime(startTime);
                editor.getComponent();
            }
            this.setTemplateProduct(editor, template, include, group);
            collection.add((IMObject)copy);
            collection.setEditor((IMObject)copy, editor);
            this.setModified(copy, true);
            result.add(copy);
            copy = null;
        }
        context.setClinician(currentClinician);
        return result;
    }

    protected void setTemplateProduct(ActItemEditor editor, Product template, TemplateProduct product, int sequence) {
        editor.setProduct(product, template, sequence);
    }

    protected Collection<TemplateProduct> getProductIncludes(Product template, Party patient, BigDecimal quantity) {
        Weight weight = Weight.ZERO;
        if (patient != null) {
            PatientRules rules = ServiceHelper.getBean(PatientRules.class);
            weight = rules.getWeight(patient);
        }
        ProductTemplateExpander expander = this.getProductTemplateExpander();
        return expander.expand(template, weight, quantity, this.getContext().getCache());
    }

    protected ProductTemplateExpander getProductTemplateExpander() {
        return new ProductTemplateExpander(false, null, null);
    }

    protected ProductListener getProductListener() {
        return this.productListener;
    }

    private void onProductChanged(ActItemEditor editor, Product product) {
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            this.expandTemplate(editor, product, BigDecimal.ONE);
        }
    }

    private boolean excludeObjectWithDefaultValues() {
        IMObjectEditor editor = this.getCurrentEditor();
        boolean excluded = false;
        if (this.excludeDefaultValueObject && editor != null) {
            CollectionPropertyEditor collection = this.getCollectionPropertyEditor();
            IMObject object = editor.getObject();
            List list = collection.getObjects();
            if (this.hasDefaultValues(editor)) {
                int inListSize;
                boolean inList = list.contains(object);
                int n = inListSize = inList ? list.size() : list.size() + 1;
                if (inListSize - 1 >= collection.getMinCardinality()) {
                    collection.remove(object);
                    excluded = true;
                } else if (inListSize - 1 < collection.getMinCardinality()) {
                    if (!inList) {
                        this.addEdited(editor);
                    }
                } else {
                    excluded = true;
                }
            } else {
                this.addEdited(editor);
            }
        }
        return excluded;
    }

    private boolean hasDefaultValues(IMObjectEditor editor) {
        Boolean changed;
        boolean result = false;
        IMObject object = editor.getObject();
        if (object.isNew() && (changed = this.modified.get(object.getObjectReference())) != null && !changed.booleanValue()) {
            result = true;
        }
        return result;
    }

    private boolean needsTemplateExpansion(IMObjectEditor editor) {
        if (editor instanceof ActItemEditor) {
            Reference product = ((ActItemEditor)editor).getProductRef();
            return TypeHelper.isA((Reference)product, (String)"product.template");
        }
        return false;
    }

    private static class ActItemCopyHandler
    extends ActCopyHandler {
        private ActItemCopyHandler() {
        }

        public IMObject getObject(IMObject object, ArchetypeService service) {
            Participation participant;
            Object result = object instanceof Participation ? (TypeHelper.isA((IMObject)(participant = (Participation)object), (String)"participation.product") ? null : super.getObject(object, service)) : super.getObject(object, service);
            return result;
        }

        protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
            boolean result = super.isCopyable(archetype, node, source);
            if (result && TypeHelper.isA((org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, (String[])new String[]{"act.customerAccountInvoiceItem", "act.customerAccountCreditItem", "act.customerAccountCounterItem"})) {
                String name = node.getName();
                result = "quantity".equals(name) || "patient".equals(name) || "product".equals(name) || "clinician".equals(name);
            }
            return result;
        }
    }
}

