/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditorFactory;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.act.ActLayoutStrategy;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;

public abstract class ActEditor
extends AbstractActEditor {
    private final boolean editItems;
    private ActRelationshipCollectionEditor editor;

    protected ActEditor(Act act, IMObject parent, LayoutContext context) {
        this(act, parent, true, context);
    }

    protected ActEditor(Act act, IMObject parent, boolean editItems, LayoutContext context) {
        super(act, parent, context);
        this.editItems = editItems;
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return (ActRelationshipCollectionEditor)IMObjectCollectionEditorFactory.create(items, (IMObject)act, this.getLayoutContext());
    }

    protected ActRelationshipCollectionEditor getItems() {
        CollectionProperty items;
        if (this.editor == null && this.editItems && (items = (CollectionProperty)this.getProperty("items")) != null && !items.isHidden()) {
            this.editor = this.createItemsEditor(this.getObject(), items);
            this.editor.addModifiableListener(new ModifiableListener(){

                @Override
                public void modified(Modifiable modifiable) {
                    ActEditor.this.onItemsChanged();
                }
            });
            this.addEditor(this.editor);
        }
        return this.editor;
    }

    @Override
    protected void doSave() {
        this.saveObject();
        this.saveChildren();
        this.updateSavedStatus();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        ActRelationshipCollectionEditor items = this.getItems();
        if (items != null) {
            return new ActLayoutStrategy(items);
        }
        if (this.getProperty("items") != null) {
            return new ActLayoutStrategy(false);
        }
        return super.createLayoutStrategy();
    }

    protected void onItemsChanged() {
    }
}

