/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ParticipationCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.edit.act.ParticipationHelper;
import org.openvpms.web.component.im.edit.act.ParticipationMonitor;
import org.openvpms.web.component.im.edit.act.SingleParticipationCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractActEditor
extends AbstractIMObjectEditor {
    protected static final String START_TIME = "startTime";
    protected static final String END_TIME = "endTime";
    private final ModifiableListener startTimeListener;
    private final ModifiableListener endTimeListener;
    private final Map<String, ParticipationMonitor<?>> monitors = new HashMap();
    private String savedStatus;

    public AbstractActEditor(Act act, IMObject parent, LayoutContext context) {
        super((IMObject)act, parent, context);
        this.startTimeListener = modifiable -> this.onStartTimeChanged();
        this.endTimeListener = modifiable -> this.onEndTimeChanged();
        this.savedStatus = !act.isNew() ? act.getStatus() : null;
    }

    public Act getObject() {
        return (Act)super.getObject();
    }

    public Date getStartTime() {
        return this.getObject().getActivityStartTime();
    }

    public void setStartTime(Date time) {
        this.setStartTime(time, false);
    }

    public Date getEndTime() {
        return this.getObject().getActivityEndTime();
    }

    public void setEndTime(Date time) {
        this.setEndTime(time, false);
    }

    public void setStatus(String status) {
        this.getProperty("status").setValue(status);
    }

    public String getStatus() {
        return this.getObject().getStatus();
    }

    public String getSavedStatus() {
        return this.savedStatus;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = super.doValidation(validator);
        if (result) {
            result = this.validateStartEndTimes(validator);
        }
        return result;
    }

    @Override
    protected void doSave() {
        super.doSave();
        this.updateSavedStatus();
    }

    protected void updateSavedStatus() {
        this.savedStatus = this.getStatus();
    }

    @Override
    protected void checkDeletePreconditions() {
        super.checkDeletePreconditions();
        if ("POSTED".equals(this.getSavedStatus())) {
            throw new IllegalStateException("Cannot delete POSTED " + this.getDisplayName());
        }
    }

    protected void initParticipant(String name, IMObject entity) {
        Reference ref = entity != null ? entity.getObjectReference() : null;
        this.initParticipant(name, ref);
    }

    protected void initParticipant(String name, Reference entity) {
        CollectionProperty property = this.getCollectionProperty(name);
        if (property != null) {
            boolean create = entity != null || property.isRequired();
            Participation participation = ParticipationHelper.getParticipation(property, false);
            if (participation == null) {
                if (create) {
                    this.setParticipant(name, entity);
                }
            } else if (participation.getEntity() == null && this.setParticipant(entity, participation)) {
                property.refresh();
            }
        }
    }

    protected boolean setParticipant(String name, Entity entity) {
        boolean modified;
        ParticipationEditor<Entity> editor = this.getParticipationEditor(name, false);
        if (editor != null) {
            modified = editor.setEntity(entity);
        } else {
            Reference ref = entity != null ? entity.getObjectReference() : null;
            modified = this.setParticipant(name, ref);
        }
        return modified;
    }

    protected boolean setParticipant(String name, Reference entity) {
        boolean modified = false;
        ParticipationEditor editor = this.getParticipationEditor(name, false);
        if (editor != null) {
            modified = editor.setEntityRef(entity);
        } else {
            boolean remove;
            CollectionProperty property = this.getCollectionProperty(name);
            if (property == null) {
                throw new IllegalArgumentException("Invalid node: " + name);
            }
            boolean bl = remove = entity == null && property.getMinCardinality() == 0 && property.getMaxCardinality() == 1;
            if (remove) {
                if (!property.getValues().isEmpty()) {
                    modified = property.remove(property.getValues().get(0));
                }
            } else {
                Participation participant = ParticipationHelper.getParticipation(property, false);
                if (participant == null) {
                    modified = this.addParticipant(property, entity);
                } else if (this.setParticipant(entity, participant)) {
                    modified = true;
                    property.refresh();
                }
            }
        }
        return modified;
    }

    protected <T extends Entity> void monitorParticipation(String name, Consumer<T> listener) {
        ParticipationCollectionEditor participationEditor;
        int maxCardinality;
        Editor editor = this.getEditor(name, false);
        if (editor instanceof ParticipationCollectionEditor && (maxCardinality = (participationEditor = (ParticipationCollectionEditor)editor).getCollection().getMaxCardinality()) == 1) {
            ParticipationMonitor<?> existing = this.monitors.get(name);
            if (existing != null) {
                existing.dispose();
            }
            this.monitors.put(name, new ParticipationMonitor<T>(participationEditor, listener));
        }
    }

    protected Reference getParticipantRef(String name) {
        IMObjectBean bean;
        ParticipationEditor editor = this.getParticipationEditor(name, false);
        Object result = editor != null ? editor.getEntityRef() : ((bean = this.getBean((IMObject)this.getObject())).hasNode(name) ? bean.getTargetRef(name) : null);
        return result;
    }

    protected Entity getParticipant(String name) {
        Reference ref = this.getParticipantRef(name);
        return (Entity)this.getObject(ref);
    }

    protected boolean addParticipant(String name, Entity entity) {
        CollectionProperty property = this.getCollectionProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Argument 'name' does not refer to a valid node: " + name);
        }
        return this.addParticipant(property, entity);
    }

    protected boolean removeParticipant(String name, Entity entity) {
        boolean removed = false;
        CollectionProperty property = this.getCollectionProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Argument 'name' does not refer to a valid node: " + name);
        }
        Reference reference = entity.getObjectReference();
        for (Object value : property.getValues()) {
            Participation participation = (Participation)value;
            if (!Objects.equals(reference, participation.getEntity())) continue;
            removed = property.remove(participation);
            break;
        }
        return removed;
    }

    protected List<Entity> getParticipants(String name) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        CollectionProperty property = this.getCollectionProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Argument 'name' does not refer to a valid node: " + name);
        }
        for (Object value : property.getValues()) {
            Participation participation = (Participation)value;
            Entity entity = (Entity)this.getObject(participation.getTarget());
            if (entity == null) continue;
            result.add(entity);
        }
        return result;
    }

    protected <T extends Entity> ParticipationEditor<T> getParticipationEditor(String name, boolean create) {
        IMObjectEditor current;
        ParticipationEditor result = null;
        Editor editor = this.getEditor(name, create);
        if (editor instanceof ParticipationEditor) {
            result = (ParticipationEditor)editor;
        } else if (editor instanceof ParticipationCollectionEditor) {
            IMObjectEditor current2;
            ParticipationCollectionEditor collectionEditor = (ParticipationCollectionEditor)editor;
            if (collectionEditor.getEditor() instanceof SingleParticipationCollectionEditor && (current2 = collectionEditor.getCurrentEditor()) instanceof ParticipationEditor) {
                result = (ParticipationEditor)current2;
            }
        } else if (editor instanceof SingleParticipationCollectionEditor && (current = ((SingleParticipationCollectionEditor)editor).getCurrentEditor()) instanceof ParticipationEditor) {
            result = (ParticipationEditor)current;
        }
        return result;
    }

    protected void setStartTime(Date time, boolean disable) {
        Property startTime = this.getProperty(START_TIME);
        if (disable) {
            this.removeStartEndTimeListeners();
        }
        startTime.setValue(time);
        if (disable) {
            this.addStartEndTimeListeners();
        }
    }

    protected void setEndTime(Date time, boolean disable) {
        Property endTime = this.getProperty(END_TIME);
        if (disable) {
            this.removeStartEndTimeListeners();
        }
        endTime.setValue(time);
        if (disable) {
            this.addStartEndTimeListeners();
        }
    }

    protected void addStartEndTimeListeners() {
        Property endTime;
        Property startTime = this.getProperty(START_TIME);
        if (startTime != null) {
            startTime.addModifiableListener(this.startTimeListener);
        }
        if ((endTime = this.getProperty(END_TIME)) != null) {
            endTime.addModifiableListener(this.endTimeListener);
        }
    }

    protected void removeStartEndTimeListeners() {
        Property endTime;
        Property startTime = this.getProperty(START_TIME);
        if (startTime != null) {
            startTime.removeModifiableListener(this.startTimeListener);
        }
        if ((endTime = this.getProperty(END_TIME)) != null) {
            endTime.removeModifiableListener(this.endTimeListener);
        }
    }

    protected void onStartTimeChanged() {
        Date start = this.getStartTime();
        Date end = this.getEndTime();
        if (start != null && end != null && start.compareTo(end) > 0) {
            this.setStartTime(end, true);
        }
    }

    protected void onEndTimeChanged() {
        Date start = this.getStartTime();
        Date end = this.getEndTime();
        if (start != null && end != null && end.compareTo(start) < 0) {
            this.setEndTime(start, true);
        }
    }

    protected boolean validateStartEndTimes(Validator validator) {
        boolean result = true;
        Date start = this.getStartTime();
        Date end = this.getEndTime();
        if (start != null && end != null && start.getTime() > end.getTime()) {
            String startName = this.getPropertyDisplayName(START_TIME);
            String endName = this.getPropertyDisplayName(END_TIME);
            String message = Messages.format((String)"act.validation.startGreaterThanEnd", (Object[])new Object[]{startName, endName});
            validator.add((Modifiable)this, new ValidatorError(message));
            result = false;
        }
        return result;
    }

    protected String getPropertyDisplayName(String name) {
        Property property = this.getProperty(name);
        return property != null ? property.getDisplayName() : name;
    }

    private boolean addParticipant(CollectionProperty property, Entity entity) {
        return this.addParticipant(property, entity != null ? entity.getObjectReference() : null);
    }

    private boolean addParticipant(CollectionProperty property, Reference entity) {
        boolean result = false;
        Participation participation = ParticipationHelper.create(property);
        if (participation != null) {
            this.setParticipant(entity, participation);
            property.add(participation);
            result = true;
        }
        return result;
    }

    private boolean setParticipant(Reference entity, Participation participation) {
        boolean modified = false;
        if (participation.getAct() == null) {
            participation.setAct(this.getObject().getObjectReference());
            modified = true;
        }
        if (!Objects.equals(participation.getEntity(), entity)) {
            participation.setEntity(entity);
            modified = true;
        }
        return modified;
    }
}

