/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractEditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreationListener;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;

public abstract class SingleIMObjectCollectionEditor
extends AbstractEditableIMObjectCollectionEditor {
    private Component container;

    public SingleIMObjectCollectionEditor(CollectionProperty editor, IMObject object, LayoutContext context) {
        super(editor, object, context);
    }

    protected SingleIMObjectCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        super(editor, object, context);
    }

    @Override
    public IMObject create() {
        String[] shortNames;
        IMObject result = null;
        CollectionPropertyEditor collection = this.getCollectionPropertyEditor();
        List objects = collection.getObjects();
        if (objects.isEmpty() && (shortNames = collection.getArchetypeRange()).length == 1) {
            String shortName = shortNames[0];
            result = IMObjectCreator.create(shortName);
            IMObjectCreationListener listener = this.getCreationListener();
            if (result != null && listener != null) {
                listener.created(result);
            }
        }
        return result;
    }

    @Override
    public void refresh() {
    }

    @Override
    public FocusGroup getFocusGroup() {
        IMObjectEditor editor = this.getCurrentEditor();
        return editor != null ? editor.getFocusGroup() : null;
    }

    @Override
    protected Component doLayout(LayoutContext context) {
        this.container = new Row();
        this.container.add(this.createComponent());
        return this.container;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        this.mapObject();
        return this.isEmpty() || super.doValidation(validator);
    }

    @Override
    protected void onModified(Modifiable modifiable) {
        super.onModified(modifiable);
        this.mapObject();
    }

    @Override
    protected void doSave() {
        this.mapObject();
        if (this.isEmpty()) {
            this.getCollectionPropertyEditor().save();
            IMObjectEditor editor = this.getCurrentEditor();
            if (editor != null && !editor.getObject().isNew()) {
                boolean hasFocus = editor.getFocusGroup().hasFocus();
                this.container.removeAll();
                this.container.add(this.createComponent());
                if (hasFocus && (editor = this.getCurrentEditor()) != null) {
                    editor.getFocusGroup().setFocus();
                }
            }
        } else {
            super.doSave();
        }
    }

    protected abstract boolean isEmpty();

    private boolean mapObject() {
        boolean result = false;
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null) {
            CollectionPropertyEditor collection = this.getCollectionPropertyEditor();
            if (this.isEmpty()) {
                collection.remove(editor.getObject());
            } else if (editor.isModified()) {
                result = true;
                collection.add(editor.getObject());
            }
        }
        return result;
    }

    private Component createComponent() {
        Component component;
        IMObject object;
        CollectionPropertyEditor collection = this.getCollectionPropertyEditor();
        String[] shortNames = collection.getArchetypeRange();
        List objects = collection.getObjects();
        String shortName = shortNames[0];
        if (objects.isEmpty()) {
            object = IMObjectCreator.create(shortName);
            IMObjectCreationListener listener = this.getCreationListener();
            if (object != null && listener != null) {
                listener.created(object);
            }
        } else {
            object = (IMObject)objects.get(0);
        }
        if (object != null) {
            IMObjectEditor editor = this.getEditor(object);
            this.setCurrentEditor(editor);
            component = editor.getComponent();
            if (!this.mapObject() && object.isNew()) {
                this.clearModified();
            }
        } else {
            String displayName = DescriptorHelper.getDisplayName((String)shortName, (ArchetypeService)this.getService());
            if (displayName == null) {
                displayName = shortName;
            }
            String message = Messages.format((String)"imobject.create.failed", (Object[])new Object[]{displayName});
            Label label = LabelFactory.create();
            label.setText(message);
            component = label;
        }
        return component;
    }
}

