/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.Objects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.edit.DefaultCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.DefaultCollectionResultSetFactory;
import org.openvpms.web.component.im.edit.IMTableCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.table.TableNavigator;

public abstract class IMObjectTableCollectionEditor
extends IMTableCollectionEditor<IMObject> {
    private final CollectionResultSetFactory resultSetFactory;

    public IMObjectTableCollectionEditor(CollectionProperty property, IMObject object, LayoutContext context) {
        this(new DefaultCollectionPropertyEditor(property), object, context);
    }

    protected IMObjectTableCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        this(editor, object, context, DefaultCollectionResultSetFactory.INSTANCE);
    }

    protected IMObjectTableCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext context, CollectionResultSetFactory factory) {
        super(editor, object, context);
        this.resultSetFactory = factory;
    }

    @Override
    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        CollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        return this.resultSetFactory.createTableModel(editor, this.getObject(), context);
    }

    @Override
    protected void setSelected(IMObject object) {
        PagedIMTable<IMObject> table = this.getTable();
        IMObject current = (IMObject)table.getSelected();
        if (!Objects.equals(current, object)) {
            if (!table.getTable().getObjects().contains(object)) {
                IPage page;
                ResultSet set = table.getResultSet();
                int index = 0;
                while ((page = set.getPage(index)) != null && !page.getResults().contains(object)) {
                    ++index;
                }
                if (page != null) {
                    table.getModel().setPage(index);
                }
            }
            table.setSelected(object);
        }
        this.enableNavigation(table.getSelected() != null, true);
    }

    @Override
    protected IMObject getSelected() {
        return (IMObject)this.getTable().getSelected();
    }

    @Override
    protected IMObject selectPrevious() {
        IMObject result = null;
        PagedIMTable table = this.getTable();
        TableNavigator navigator = table.getNavigator();
        if (navigator.selectPreviousRow()) {
            result = (IMObject)table.getSelected();
            this.setSelected(result);
        }
        return result;
    }

    @Override
    protected IMObject selectNext() {
        IMObject result = null;
        PagedIMTable table = this.getTable();
        TableNavigator navigator = table.getNavigator();
        if (navigator.selectNextRow()) {
            result = (IMObject)table.getSelected();
            this.setSelected(result);
        }
        return result;
    }

    @Override
    protected ResultSet<IMObject> createResultSet() {
        return this.resultSetFactory.createResultSet(this.getCollectionPropertyEditor(), this.getContext().getContext());
    }
}

