/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.lang.reflect.InvocationTargetException;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;

public class IMObjectReferenceEditorFactory {
    private static ArchetypeHandlers<IMObjectReferenceEditor> editors;

    private IMObjectReferenceEditorFactory() {
    }

    public static <T extends IMObject> IMObjectReferenceEditor<T> create(Property property, IMObject parent, LayoutContext context) {
        IMObjectReferenceEditor result = null;
        String[] archetypes = property.getArchetypeRange();
        ArchetypeHandler handler = IMObjectReferenceEditorFactory.getEditors().getHandler(archetypes);
        if (handler != null) {
            try {
                result = (IMObjectReferenceEditor)handler.create(new Object[]{property, parent, context}, new Class[]{Property.class, IMObject.class, LayoutContext.class});
            }
            catch (InvocationTargetException exception) {
                if (exception.getCause() instanceof OpenVPMSException) {
                    throw (OpenVPMSException)exception.getCause();
                }
                throw new IllegalStateException("Failed to construct " + handler.getType().getName() + " for " + property.getName(), exception);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to construct " + handler.getType().getName() + " for " + property.getName(), throwable);
            }
        }
        if (result == null) {
            result = new DefaultIMObjectReferenceEditor(property, parent, context);
        }
        return result;
    }

    private static synchronized ArchetypeHandlers<IMObjectReferenceEditor> getEditors() {
        if (editors == null) {
            editors = new ArchetypeHandlers("IMObjectReferenceEditorFactory.properties", IMObjectReferenceEditor.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return editors;
    }
}

