/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class EditBrowserDialog<T extends IMObject>
extends BrowserDialog<T> {
    public static final String EDIT_ID = "button.edit";
    private final IMObjectActions<T> actions;
    private final Context context;
    private final DoubleClickMonitor click = new DoubleClickMonitor();

    public EditBrowserDialog(String title, String[] buttons, Browser<T> browser, IMObjectActions<T> actions, Context context, HelpContext help) {
        this(title, buttons, browser, actions, false, context, help);
    }

    public EditBrowserDialog(String title, String[] buttons, Browser<T> browser, IMObjectActions<T> actions, boolean addNew, Context context, HelpContext help) {
        super(title, null, buttons, browser, addNew, help);
        this.actions = actions;
        this.context = context;
        this.setCloseOnSelection(false);
    }

    @Override
    protected void onOK() {
        this.close("ok");
    }

    @Override
    protected void setSelected(T object) {
        super.setSelected(object);
        if (object != null) {
            boolean enabled = this.actions.canEdit(object);
            this.getButtons().setEnabled(EDIT_ID, enabled);
        }
    }

    @Override
    protected void onSelected(T object) {
        super.onSelected(object);
        if (this.actions.canEdit(object) && this.click.isDoubleClick((Object)object.getId())) {
            this.onEdit(object);
        }
    }

    protected void onButton(String button) {
        if (EDIT_ID.equals(button)) {
            IMObject selected = (IMObject)this.getSelected();
            if (selected != null) {
                this.onEdit(selected);
            }
        } else {
            super.onButton(button);
        }
    }

    private void onEdit(T object) {
        T current = IMObjectHelper.reload(object);
        if (current == null) {
            String displayName = DescriptorHelper.getDisplayName(object, (ArchetypeService)ServiceHelper.getArchetypeService());
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{displayName}));
        } else if (this.actions.canEdit(current)) {
            final FocusCommand focus = new FocusCommand();
            HelpContext help = this.getHelpContext().topic(object, "edit");
            DefaultLayoutContext context = new DefaultLayoutContext(true, this.context, help);
            IMObjectEditor editor = context.getEditorFactory().create((IMObject)current, context);
            EditDialog dialog = ServiceHelper.getBean(EditDialogFactory.class).create(editor, this.context);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                protected void onAction(PopupDialog dialog) {
                    Browser browser = EditBrowserDialog.this.getBrowser();
                    browser.query();
                    EditBrowserDialog.this.setSelected((IMObject)browser.getSelected());
                    focus.restore();
                }
            });
            dialog.show();
        }
    }
}

