/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.GridLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.util.StyleSheetHelper;

public class AlertManager {
    private final Component container;
    private final AlertListener listener;
    private final int maxAlerts;
    private final List<Alert> alerts = new ArrayList<Alert>();
    private int alertCount;
    private static final int OFFSET = 5;

    public AlertManager(Component container, int maxAlerts) {
        this.container = container;
        this.maxAlerts = maxAlerts;
        this.listener = new AlertListener(){

            @Override
            public String onAlert(String message) {
                return AlertManager.this.show(message);
            }

            @Override
            public void onAlert(String id, String message) {
                AlertManager.this.show(id, message);
            }

            @Override
            public String onAlert(String message, AlertListener.Category category) {
                return AlertManager.this.show(message, category);
            }

            @Override
            public void onAlert(String id, String message, AlertListener.Category category) {
                AlertManager.this.show(id, message, category);
            }

            @Override
            public void cancel(String id) {
                AlertManager.this.cancelAlert(id);
            }
        };
    }

    public AlertListener getListener() {
        return this.listener;
    }

    public void clear() {
        for (Alert alert : this.alerts.toArray(new Alert[0])) {
            alert.userClose();
        }
    }

    public String show(String message) {
        return this.show(message, AlertListener.Category.INFO);
    }

    public String show(String message, AlertListener.Category category) {
        String id = UUID.randomUUID().toString();
        this.show(id, message, category);
        return id;
    }

    public void show(String id, String message) {
        this.show(id, message, AlertListener.Category.INFO);
    }

    public void show(String id, String message, AlertListener.Category category) {
        if (this.alerts.size() < this.maxAlerts) {
            final Alert alert = new Alert(id, message, category);
            int y = 5;
            for (Alert existing : this.alerts) {
                y = this.getNextY(existing);
            }
            alert.setPositionY(new Extent(y));
            this.getContentPane().add((Component)alert);
            alert.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    AlertManager.this.remove(alert);
                }
            });
            this.alerts.add(alert);
            ++this.alertCount;
        }
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    protected Component getContentPane() {
        Component component;
        for (component = this.container; component != null && !(component instanceof ContentPane); component = component.getParent()) {
        }
        if (component == null) {
            component = ApplicationInstance.getActive().getDefaultWindow().getContent();
        }
        return component;
    }

    protected void cancelAlert(String id) {
        for (Alert alert : this.alerts.toArray(new Alert[0])) {
            if (!Objects.equals(alert.id, id)) continue;
            alert.userClose();
        }
    }

    private int getNextY(WindowPane alert) {
        Extent position = alert.getPositionY();
        int y = position != null ? position.getValue() : 5;
        Extent height = alert.getHeight();
        y = height != null ? (y += height.getValue() + 5) : (y += 5);
        return y;
    }

    private void remove(Alert alert) {
        this.alerts.remove((Object)alert);
        this.shuffle();
    }

    private void shuffle() {
        int y = 5;
        for (WindowPane windowPane : this.alerts) {
            windowPane.setPositionY(new Extent(y));
            y = this.getNextY(windowPane);
        }
    }

    private static class Alert
    extends Message {
        private final String id;

        public Alert(String id, String message, AlertListener.Category category) {
            super(message, category == AlertListener.Category.INFO ? "InformationMessage" : "ErrorMessage");
            this.id = id;
        }
    }

    private static class Message
    extends WindowPane {
        Message(String message, String styleName) {
            this.setStyleName(styleName);
            this.setClosable(false);
            this.setPositionX(new Extent(5));
            this.setPositionY(new Extent(5));
            int fontSize = StyleSheetHelper.getProperty((String)"font.size", (int)10);
            Extent height = this.getHeight(message, fontSize);
            this.setHeight(height);
            this.setMinimumHeight(height);
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setStyleName(styleName);
            label.setText(message);
            Button button = ButtonFactory.create(null, (String)"Message.close");
            button.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    this.userClose();
                }
            });
            GridLayoutData layoutData = new GridLayoutData();
            label.setLayoutData((LayoutData)layoutData);
            Grid grid = GridFactory.create((int)2, (Component[])new Component[]{label, button});
            grid.setColumnWidth(0, Styles.FULL_WIDTH);
            grid.setWidth(Styles.FULL_WIDTH);
            grid.setHeight(Styles.FULL_HEIGHT);
            this.add((Component)grid);
        }

        private Extent getHeight(String message, int fontSize) {
            int lines = StringUtils.countMatches((CharSequence)message, (CharSequence)"\n");
            if (lines == 0) {
                lines = message.length() / 60;
            }
            if ((lines += 3) > 10) {
                lines = 10;
            }
            return new Extent(fontSize * lines);
        }
    }
}

