/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.DefaultCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreationListener;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;

public abstract class AbstractEditableIMObjectCollectionEditor
extends AbstractIMObjectCollectionEditor
implements EditableIMObjectCollectionEditor {
    private IMObjectEditor editor;
    private boolean cardinalityReadOnly = false;
    private IMObjectCreationListener creationListener;
    private RemoveConfirmationHandler removeConfirmationHandler;

    protected AbstractEditableIMObjectCollectionEditor(CollectionProperty editor, IMObject object, LayoutContext context) {
        this(new DefaultCollectionPropertyEditor(editor), object, context);
    }

    protected AbstractEditableIMObjectCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        super(editor, object, context);
    }

    @Override
    public void dispose() {
        super.dispose();
        ModifiableListener listener = this.getModifiableListener();
        for (Editor editor : this.getEditors()) {
            editor.removeModifiableListener(listener);
            editor.setErrorListener(null);
            editor.dispose();
        }
    }

    @Override
    public void setCardinalityReadOnly(boolean readOnly) {
        this.cardinalityReadOnly = readOnly;
    }

    @Override
    public boolean isCardinalityReadOnly() {
        return this.cardinalityReadOnly;
    }

    @Override
    public void setCreationListener(IMObjectCreationListener listener) {
        this.creationListener = listener;
    }

    @Override
    public IMObjectCreationListener getCreationListener() {
        return this.creationListener;
    }

    @Override
    public void setRemoveConfirmationHandler(RemoveConfirmationHandler handler) {
        this.removeConfirmationHandler = handler;
    }

    @Override
    public RemoveConfirmationHandler getRemoveConfirmationHandler() {
        return this.removeConfirmationHandler;
    }

    @Override
    public boolean isModified() {
        boolean modified = super.isModified();
        if (!modified && this.editor != null) {
            modified = this.editor.isModified();
        }
        return modified;
    }

    @Override
    public void clearModified() {
        super.clearModified();
        if (this.editor != null) {
            this.editor.clearModified();
        }
    }

    @Override
    public void remove(IMObject object) {
        super.remove(object);
        if (this.editor != null && this.editor.getObject() == object) {
            this.removeCurrentEditor();
        }
    }

    @Override
    public IMObjectEditor getEditor(IMObject object) {
        IMObjectEditor editor;
        IMObjectEditor current = this.getCurrentEditor();
        if (current != null && current.getObject().equals(object)) {
            editor = current;
        } else {
            editor = this.getCollectionPropertyEditor().getEditor(object);
            if (editor == null) {
                DefaultLayoutContext context = new DefaultLayoutContext(this.getContext());
                editor = this.createEditor(object, context);
                this.addEditor(object, editor);
            }
        }
        return editor;
    }

    public boolean hasEditor(IMObject object) {
        return this.getCollectionPropertyEditor().getEditor(object) != null;
    }

    @Override
    public IMObjectEditor getCurrentEditor() {
        return this.editor;
    }

    @Override
    public Collection<IMObjectEditor> getEditors() {
        LinkedHashSet<IMObjectEditor> editors = new LinkedHashSet<IMObjectEditor>(this.getCollectionPropertyEditor().getEditors());
        if (this.getCurrentEditor() != null) {
            editors.add(this.getCurrentEditor());
        }
        return editors;
    }

    @Override
    public Collection<IMObject> getCurrentObjects() {
        LinkedHashSet<IMObject> result = new LinkedHashSet<IMObject>(this.getCollectionPropertyEditor().getObjects());
        if (this.editor != null) {
            result.add(this.editor.getObject());
        }
        return result;
    }

    @Override
    public IMObjectEditor getFirstEditor(boolean create) {
        IMObject object = null;
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor == null) {
            Collection<IMObject> objects = this.getCurrentObjects();
            if (!objects.isEmpty()) {
                object = objects.iterator().next();
            } else if (create && (object = this.create()) != null) {
                this.add(object);
            }
            if (object != null) {
                editor = this.getEditor(object);
            }
        }
        return editor;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = true;
        if (this.editor != null) {
            result = this.addCurrentEdits(validator);
        }
        if (result) {
            result = super.doValidation(validator);
        }
        return result;
    }

    protected void setCurrentEditor(IMObjectEditor editor) {
        this.editor = editor;
    }

    protected void removeCurrentEditor() {
        this.setCurrentEditor(null);
    }

    protected IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return context.getEditorFactory().create(object, this.getObject(), context);
    }

    protected void addEditor(IMObject object, IMObjectEditor editor) {
        editor.addModifiableListener(this.getModifiableListener());
        editor.setErrorListener(this.getErrorListener());
        this.getCollectionPropertyEditor().setEditor(object, editor);
    }

    protected boolean addCurrentEdits(Validator validator) {
        boolean valid = true;
        if (this.editor != null && (valid = validator.validate(this.editor))) {
            this.addEdited(this.editor);
        }
        return valid;
    }

    protected boolean addEdited(IMObjectEditor editor) {
        IMObject object = editor.getObject();
        boolean added = this.add(object);
        this.addEditor(object, editor);
        return added;
    }

    @Override
    protected void doSave() {
        if (this.editor != null) {
            this.addEdited(this.editor);
        }
        super.doSave();
    }
}

