/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.report.ParameterType;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.property.AbstractPropertyComponentFactory;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.system.ServiceHelper;

public class ReportParameters {
    private final Component component;
    private final List<Property> properties;
    private final FocusGroup focus = new FocusGroup(this.getClass().getSimpleName());

    public ReportParameters(Set<ParameterType> parameters, Variables variables, int columns) {
        this(parameters, null, variables, columns, false);
    }

    public ReportParameters(Set<ParameterType> parameters, IMObject context, Variables variables, int columns, boolean largeTextFields) {
        this.properties = this.createProperties(parameters, context, variables);
        if (this.properties.size() > 0) {
            Grid grid;
            if (columns == 1) {
                grid = GridFactory.create((int)2);
                grid.setColumnWidth(0, new Extent(20, 2));
                grid.setColumnWidth(1, new Extent(80, 2));
            } else {
                grid = GridFactory.create((int)(columns * 2));
            }
            grid.setWidth(Styles.FULL_WIDTH);
            ComponentFactory factory = new ComponentFactory(largeTextFields);
            for (Property property : this.properties) {
                if (!property.isBoolean() && !property.isString() && !property.isNumeric() && !property.isDate()) continue;
                Component component = factory.create(property);
                Label label = LabelFactory.create(null, (String)"default.grid");
                label.setText(property.getDisplayName());
                grid.add((Component)label);
                grid.add(component);
                this.focus.add(component);
            }
            this.component = grid;
        } else {
            this.component = LabelFactory.create((String)"reporting.run.noparameters");
        }
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean validate() {
        boolean valid = true;
        DefaultValidator validator = new DefaultValidator();
        for (Property property : this.properties) {
            if (validator.validate(property)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            ValidationHelper.showError(validator);
        }
        return valid;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Property property : this.properties) {
            result.put(property.getName(), property.getValue());
        }
        return result;
    }

    private List<Property> createProperties(Set<ParameterType> parameters, Object context, Variables variables) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (ParameterType type : parameters) {
            Object defaultValue;
            if (type.isSystem()) continue;
            SimpleProperty property = new SimpleProperty(type.getName(), type.getType());
            if (!StringUtils.isEmpty((CharSequence)type.getDescription())) {
                property.setDisplayName(type.getDescription());
            }
            if ((property.isBoolean() || property.isString() || property.isNumeric() || property.isDate()) && (defaultValue = type.getDefaultValue()) != null) {
                property.setValue(defaultValue);
            }
            if (property.isString()) {
                Macros macros = ServiceHelper.getMacros();
                property.setTransformer(new StringPropertyTransformer(property, true, macros, context, variables));
                property.setMaxLength(-1);
            }
            result.add(property);
        }
        return result;
    }

    private static class ComponentFactory
    extends AbstractPropertyComponentFactory {
        private final int rows;

        private ComponentFactory(boolean largeTextFields) {
            super("default");
            this.rows = largeTextFields ? 5 : 2;
        }

        @Override
        protected Component createString(Property property, int columns) {
            Component result;
            if (property.getMaxLength() == -1 || property.getMaxLength() > 255) {
                TextArea text = BoundTextComponentFactory.createTextArea(property, columns, this.rows);
                text.setWidth(new Extent(95, 2));
                result = text;
            } else {
                result = super.createString(property, columns);
            }
            return result;
        }
    }
}

