/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.io.File;
import javax.servlet.ServletContext;
import org.openvpms.archetype.rules.doc.AbstractImageService;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class ImageCache
extends AbstractImageService
implements ServletContextAware {
    private ServletContext context;
    private File dir;
    private static final Logger log = LoggerFactory.getLogger(ImageCache.class);
    private static final String TEMP_DIR = "javax.servlet.context.tempdir";

    public ImageCache(DocumentHandlers handlers, ArchetypeService service) {
        this(handlers, service, null);
    }

    public ImageCache(DocumentHandlers handlers, ArchetypeService service, File dir) {
        super(handlers, service);
        this.dir = dir;
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Argument 'dir' specifies a directory that does not exist, and cannot be created: " + dir);
        }
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    protected synchronized File getDir() {
        if (this.dir == null) {
            File root = this.context != null ? (File)this.context.getAttribute(TEMP_DIR) : new File("./");
            File cache = new File(root, "ImageCache");
            if (!cache.exists() && !cache.mkdirs()) {
                throw new IllegalStateException("Failed to create ImageCache directory: " + cache);
            }
            this.dir = cache;
            log.info("Using image cache: {}", (Object)this.dir.getAbsolutePath());
        }
        return this.dir;
    }
}

