/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.commons.lang3.StringUtils;

public class HtmlToTextFormatter {
    public String format(String html) {
        HtmlToTextBuilder builder = new HtmlToTextBuilder();
        ParserDelegator delegator = new ParserDelegator();
        try {
            delegator.parse(new StringReader(html), builder, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.getText();
    }

    private static class Element {
        private final HTML.Tag tag;
        private final Element parent;
        private final int depth;
        private int offset = 0;

        public Element(HTML.Tag tag, Element parent) {
            this.parent = parent;
            this.tag = tag;
            this.depth = this.isA(HTML.Tag.OL, HTML.Tag.UL, HTML.Tag.TR) ? (parent != null ? parent.depth + 1 : -1) : (parent == null || this.isA(HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6) ? -1 : parent.depth);
            if (this.isA(tag, HTML.Tag.TH, HTML.Tag.TD, HTML.Tag.LI) && parent != null && parent.isA(HTML.Tag.TR, HTML.Tag.OL, HTML.Tag.UL)) {
                this.offset = parent.nextOffset();
            }
        }

        public Element getParent() {
            return this.parent;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isA(HTML.Tag ... tags) {
            for (HTML.Tag other : tags) {
                if (this.tag != other) continue;
                return true;
            }
            return false;
        }

        public int getOffset() {
            return this.offset;
        }

        public int nextOffset() {
            return this.offset++;
        }
    }

    private static class HtmlToTextBuilder
    extends HTMLEditorKit.ParserCallback {
        private final StringBuilder buffer = new StringBuilder();
        Element element;

        private HtmlToTextBuilder() {
        }

        public String getText() {
            return this.buffer.toString();
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
            this.element = new Element(tag, this.element);
            if (this.element.isA(HTML.Tag.P, HTML.Tag.TABLE, HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6)) {
                this.newLine();
            } else if (tag == HTML.Tag.LI) {
                this.newLine();
                this.indent(this.element);
                Element parent = this.element.getParent();
                if (parent != null) {
                    if (parent.isA(HTML.Tag.OL)) {
                        this.buffer.append(this.element.getOffset() + 1);
                        this.buffer.append(". ");
                    } else if (parent.isA(HTML.Tag.UL)) {
                        this.buffer.append("* ");
                    }
                }
            } else if (tag == HTML.Tag.DD) {
                this.buffer.append("  ");
            } else if (this.element.isA(tag, HTML.Tag.TD, HTML.Tag.TH) && this.element.getOffset() > 0) {
                this.buffer.append(" ");
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            this.buffer.append(new String(data));
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
            if (this.element != null && this.element.isA(HTML.Tag.P, HTML.Tag.DD, HTML.Tag.DT, HTML.Tag.TR, HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6)) {
                this.newLine();
            }
            if (this.element != null) {
                this.element = this.element.getParent();
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
            if (tag == HTML.Tag.BR) {
                this.newLine();
            }
        }

        private void newLine() {
            this.buffer.append("\n");
        }

        private void indent(Element element) {
            int depth = element.getDepth();
            if (depth > 0) {
                this.buffer.append(StringUtils.repeat((String)"  ", (int)depth));
            }
        }
    }
}

