/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.openvpms.archetype.rules.doc.DelegatingDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.SupportedContentDocumentHandler;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.jasper.JRXMLDocumentHandler;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateEditor;
import org.openvpms.web.component.im.doc.EmailDocumentTemplateLayoutStrategy;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;

public class EmailDocumentTemplateEditor
extends AbstractDocumentTemplateEditor {
    protected static final String DOCUMENT_CONTENT = "DOCUMENT";
    private static final String CONTENT_TYPE = "contentType";

    public EmailDocumentTemplateEditor(Entity template, IMObject parent, LayoutContext context) {
        super(template, parent, false, null, context);
        IArchetypeService service = this.getService();
        this.setDocumentHandler((DocumentHandler)new DelegatingDocumentHandler(new DocumentHandler[]{new EmailDocumentHandler((ArchetypeService)service), new JRXMLDocumentHandler((ArchetypeService)service)}));
        this.updateDocumentState();
        this.disableMacroExpansion("subject");
        this.disableMacroExpansion("subjectSource");
        this.disableMacroExpansion("content");
        this.disableMacroExpansion("contentSource");
        this.getProperty(CONTENT_TYPE).addModifiableListener(modifiable -> this.onContentTypeChanged());
    }

    @Override
    public IMObjectEditor newInstance() {
        return new EmailDocumentTemplateEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected String getContentType() {
        return this.getProperty(CONTENT_TYPE).getString();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new EmailDocumentTemplateLayoutStrategy(this.getSelector());
    }

    @Override
    protected void doSave() {
        super.doSave();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateDefaultEmailAddress(validator);
    }

    protected boolean validateDefaultEmailAddress(Validator validator) {
        Property property = this.getProperty("defaultEmailAddress");
        String email = property.getString();
        if (email != null) {
            try {
                new InternetAddress(email, true);
            }
            catch (AddressException exception) {
                validator.add((Modifiable)property, new ValidatorError(property, exception.getMessage()));
            }
        }
        return validator.isValid();
    }

    private void onContentTypeChanged() {
        String type = this.getContentType();
        if (type != null) {
            this.updateDocumentState();
            this.onLayout();
        }
    }

    private void updateDocumentState() {
        boolean isDocument = DOCUMENT_CONTENT.equals(this.getContentType());
        this.setDocumentRequired(isDocument);
        this.setDeleteDocument(!isDocument);
    }

    private static class EmailDocumentHandler
    extends SupportedContentDocumentHandler {
        private static final String[] SUPPORTED_EXTENSIONS = new String[]{"odt", "doc", "html", "rtf"};
        private static final String[] SUPPORTED_MIME_TYPES = new String[]{"application/vnd.oasis.opendocument.text", "application/msword", "text/html", "text/rtf"};

        public EmailDocumentHandler(ArchetypeService service) {
            super(SUPPORTED_EXTENSIONS, SUPPORTED_MIME_TYPES, service);
        }
    }
}

