/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.report.ParameterType;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.doc.ParameterDialog;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.report.DocumentActReporter;
import org.openvpms.web.component.im.report.DocumentTemplateLocatorFactory;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.util.AbstractIMObjectSaveListener;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class DocumentGenerator {
    public static final String LETTER = "act.*DocumentLetter";
    private final DocumentAct act;
    private final DocumentTemplateLocatorFactory templateLocatorFactory;
    private final Context context;
    private final HelpContext help;
    private final FileNameFormatter formatter;
    private final ArchetypeService service;
    private final LookupService lookups;
    private final ReportFactory reportFactory;
    private final DocumentJobManager jobManager;
    private final DocumentRules documentRules;
    private final Listener listener;
    private String mimeType;

    public DocumentGenerator(DocumentAct act, DocumentTemplateLocatorFactory templateLocatorFactory, Context context, HelpContext help, FileNameFormatter formatter, ArchetypeService service, LookupService lookups, ReportFactory reportFactory, DocumentJobManager jobManager, DocumentRules documentRules, Listener listener) {
        this.act = act;
        this.templateLocatorFactory = templateLocatorFactory;
        this.context = context;
        this.help = help;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
        this.reportFactory = reportFactory;
        this.jobManager = jobManager;
        this.documentRules = documentRules;
        this.listener = listener;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void generate() {
        this.generate(false, false);
    }

    public void generate(boolean save, boolean version) {
        this.generate(save, version, false);
    }

    public void generate(boolean save, boolean version, boolean skip) {
        DocumentTemplate template = this.templateLocatorFactory.getTemplate((IMObject)this.act, this.context);
        if (template != null) {
            DocumentActReporter reporter = new DocumentActReporter(this.act, template, this.formatter, this.service, this.lookups, this.reportFactory);
            reporter.setFields(ReportContextFactory.create(this.context));
            this.generate(reporter, save, version, skip);
        } else if (this.act.getDocument() != null) {
            Document existing = (Document)this.service.get(this.act.getDocument(), Document.class);
            if (existing == null) {
                throw new DocumentException(DocumentException.ErrorCode.NotFound, new Object[]{DescriptorHelper.getDisplayName((IMObject)this.act, (ArchetypeService)this.service)});
            }
            this.listener.generated(existing);
        } else {
            throw new DocumentException(DocumentException.ErrorCode.NotFound, new Object[]{DescriptorHelper.getDisplayName((IMObject)this.act, (ArchetypeService)this.service)});
        }
    }

    protected Document generate(DocumentActReporter reporter) {
        DocumentTemplate.Format format;
        DocumentTemplate template;
        String type = this.mimeType;
        if (type == null && (template = reporter.getTemplate()) != null && (format = template.getOutputFormat()) != null && format.getMimeType() != null) {
            type = format.getMimeType();
        }
        return reporter.getDocument(type, false);
    }

    private void generate(DocumentActReporter reporter, boolean save, boolean version, boolean skip) {
        Job<Set> job = JobBuilder.newJob(reporter.getDisplayName(), this.context.getUser()).get(reporter::getParameterTypes).completed(parameters -> {
            if (parameters.isEmpty() || !this.act.isA(LETTER)) {
                this.generate(reporter, save, version);
            } else {
                this.promptParameters(reporter, save, version, skip);
            }
        }).cancelled(this.listener::cancelled).failed(this.listener::error).build();
        this.jobManager.runInteractive(job, Messages.get((String)"document.generate.title"), Messages.get((String)"document.generate.cancel"));
    }

    private void generate(DocumentActReporter reporter, boolean save, boolean version) {
        Job<Document> job = JobBuilder.newJob(reporter.getDisplayName(), this.context.getUser()).get(() -> this.generate(reporter)).completed(document -> this.generated((Document)document, save, version)).cancelled(this.listener::cancelled).failed(this.listener::error).build();
        this.jobManager.runInteractive(job, Messages.get((String)"document.generate.title"), Messages.get((String)"document.generate.cancel"));
    }

    private void generated(final Document document, boolean save, boolean version) {
        if (save) {
            List changes = this.documentRules.addDocument(this.act, document, version);
            SaveHelper.save((Collection<? extends IMObject>)changes, new AbstractIMObjectSaveListener(){

                @Override
                public void saved(Collection<? extends IMObject> objects) {
                    DocumentGenerator.this.listener.generated(document);
                }

                @Override
                protected void onErrorClosed() {
                    DocumentGenerator.this.listener.error(null);
                }
            });
        } else {
            this.listener.generated(document);
        }
    }

    private void promptParameters(final DocumentActReporter reporter, final boolean save, final boolean version, boolean skip) {
        Set<ParameterType> parameters = reporter.getParameterTypes();
        String title = Messages.format((String)"document.input.parameters", (Object[])new Object[]{reporter.getTemplate().getName()});
        MacroVariables variables = new MacroVariables(this.context, this.service, this.lookups);
        final ParameterDialog dialog = new ParameterDialog(title, parameters, (IMObject)this.act, this.context, this.help.subtopic("parameters"), (Variables)variables, skip, true);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                reporter.setParameters(dialog.getValues());
                DocumentGenerator.this.generate(reporter, save, version);
            }

            public void onSkip() {
                DocumentGenerator.this.listener.skipped();
            }

            public void onCancel() {
                DocumentGenerator.this.listener.cancelled();
            }
        });
        dialog.show();
    }

    public static abstract class AbstractListener
    implements Listener {
        @Override
        public void generated(Document document) {
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void skipped() {
        }

        @Override
        public void error(Throwable cause) {
            if (cause != null) {
                ErrorHelper.show(cause);
            }
        }
    }

    public static interface Listener {
        public void generated(Document var1);

        public void cancelled();

        public void skipped();

        public void error(Throwable var1);
    }
}

