/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.web.component.im.doc.DocumentEditor;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.DocumentViewerFactory;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.act.ActLayoutStrategy;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.system.ServiceHelper;

public class DocumentActLayoutStrategy
extends ActLayoutStrategy {
    public static final String DOCUMENT = "document";
    public static final String VERSIONS = "versions";
    protected static ArchetypeNodes NODES = new ArchetypeNodes().simple("document");
    protected static ArchetypeNodes VIEW_NODES = new ArchetypeNodes(NODES).excludeIfEmpty("versions");
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public DocumentActLayoutStrategy() {
        this((DocumentEditor)null, (ActRelationshipCollectionEditor)null);
    }

    public DocumentActLayoutStrategy(DocumentEditor editor, ActRelationshipCollectionEditor versionsEditor) {
        this.setArchetypeNodes(NODES);
        if (editor != null) {
            this.addComponent(new ComponentState(editor));
        }
        if (versionsEditor != null) {
            this.addComponent(new ComponentState(versionsEditor));
        }
    }

    protected void addDocumentViewers(DocumentAct act, PropertySet properties, LayoutContext context) {
        DocumentViewerFactory factory = ServiceHelper.getBean(DocumentViewerFactory.class);
        Property document = properties.get(DOCUMENT);
        Property documentTemplate = properties.get(DOCUMENT_TEMPLATE);
        if (documentTemplate != null) {
            boolean template = document != null;
            DocumentViewer viewer = factory.create(act, true, template, context);
            this.addComponent(new ComponentState(viewer.getComponent(), documentTemplate));
        }
        if (document != null) {
            DocumentViewer viewer = factory.create(act, true, context);
            this.addComponent(new ComponentState(viewer.getComponent(), document));
        }
    }
}

