/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.delete.DefaultDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IMObjectDeletionHandlerFactory
implements ApplicationContextAware {
    private ArchetypeHandlers<IMObjectDeletionHandler> deleters;
    private ApplicationContext context;

    public IMObjectDeletionHandlerFactory(IArchetypeService service) {
        this.deleters = new ArchetypeHandlers("IMObjectDeletionHandlerFactory", null, IMObjectDeletionHandler.class, (ArchetypeService)service);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public <T extends IMObject> IMObjectDeletionHandler<T> create(T object) {
        ArchetypeHandler handler = this.deleters.getHandler(object.getArchetype());
        Class type = handler != null ? handler.getType() : DefaultDeletionHandler.class;
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory((BeanFactory)this.context);
        factory.registerSingleton("object", object);
        return (IMObjectDeletionHandler)factory.createBean(type, 3, false);
    }
}

