/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.FailureReason;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AbstractIMObjectDeletionListener<T extends IMObject>
implements IMObjectDeletionListener<T> {
    private Runnable failureCallback;

    @Override
    public void deleted(T object) {
    }

    @Override
    public void deactivated(T object) {
    }

    @Override
    public void alreadyDeactivated(T object) {
    }

    @Override
    public void unsupported(T object, String reason) {
        String type = this.getDisplayName((IMObject)object);
        String title = Messages.format((String)"imobject.delete.title", (Object[])new Object[]{type});
        String message = reason == null ? Messages.format((String)"imobject.delete.unsupported", (Object[])new Object[]{this.getDisplayName((IMObject)object)}) : reason;
        this.error(title, message);
    }

    @Override
    public void failed(T object, FailureReason reason) {
        String title = Messages.get((String)"imobject.delete.failed.title");
        String message = reason.getMessage();
        if (reason.getException() != null) {
            this.error(title, message, reason.getException());
        } else {
            this.error(title, message);
        }
    }

    protected void setFailureCallback(Runnable callback) {
        this.failureCallback = callback;
    }

    protected void error(String title, String message) {
        ErrorHelper.show(title, message, this.failureCallback);
    }

    protected void error(String title, String message, Throwable cause) {
        ErrorHelper.show(title, message, (String)null, cause, this.failureCallback);
    }

    private String getDisplayName(IMObject object) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
    }
}

