/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.table.AbstractEntityObjectSetTableModel;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.system.ServiceHelper;

public abstract class CustomerPatientTableModel
extends AbstractEntityObjectSetTableModel {
    private final PatientRules patientRules;
    private boolean showCustomer;
    private boolean showPatient;
    private boolean showContact;
    private boolean showIdentity;
    private boolean showActive;
    private final boolean showActiveForCustomer;
    private static final SortConstraint CUSTOMER_ID_ASC = Constraints.sort((String)"customer.id", (boolean)true);
    private static final SortConstraint CUSTOMER_NAME_ASC = Constraints.sort((String)"customer.name", (boolean)true);
    private static final SortConstraint PATIENT_ID_ASC = Constraints.sort((String)"patient.id", (boolean)true);
    private static final SortConstraint PATIENT_NAME_ASC = Constraints.sort((String)"patient.name", (boolean)true);
    private static final int PATIENT_ID_INDEX = 5;
    private static final int PATIENT_NAME_INDEX = 6;
    private static final int PATIENT_DESC_INDEX = 7;
    private static final int CONTACT_INDEX = 8;

    public CustomerPatientTableModel(boolean showActiveForCustomer) {
        super("customer", "identity");
        this.showActiveForCustomer = showActiveForCustomer;
        this.patientRules = ServiceHelper.getBean(PatientRules.class);
    }

    public void showColumns(boolean customer, boolean patient, boolean contact, boolean identity, boolean active) {
        if (customer != this.showCustomer || patient != this.showPatient || contact != this.showContact || identity != this.showIdentity || active != this.showActive) {
            this.showCustomer = customer;
            this.showPatient = patient;
            this.showContact = contact;
            this.showIdentity = identity;
            this.showActive = active;
            this.setTableColumnModel(this.createTableColumnModel(this.showCustomer, this.showPatient, this.showContact, this.showIdentity, this.showActive));
        }
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] result = null;
        if (column == 0) {
            SortConstraint customer = Constraints.sort((String)"customer.id", (boolean)ascending);
            result = this.showPatient ? new SortConstraint[]{customer, PATIENT_NAME_ASC, PATIENT_ID_ASC} : new SortConstraint[]{customer};
        } else if (column == 1) {
            SortConstraint customer = Constraints.sort((String)"customer.name", (boolean)ascending);
            result = this.showPatient ? new SortConstraint[]{customer, CUSTOMER_ID_ASC, PATIENT_NAME_ASC, PATIENT_ID_ASC} : new SortConstraint[]{customer, CUSTOMER_ID_ASC};
        } else if (column == 5) {
            result = new SortConstraint[]{Constraints.sort((String)"patient.id", (boolean)ascending), CUSTOMER_NAME_ASC};
        } else if (column == 6) {
            result = new SortConstraint[]{Constraints.sort((String)"patient.name", (boolean)ascending), PATIENT_ID_ASC, CUSTOMER_NAME_ASC};
        } else if (column == 8) {
            SortConstraint contact = Constraints.sort((String)"contact.description", (boolean)ascending);
            result = this.showPatient ? new SortConstraint[]{contact, CUSTOMER_NAME_ASC, CUSTOMER_ID_ASC, PATIENT_NAME_ASC, PATIENT_ID_ASC} : new SortConstraint[]{contact, CUSTOMER_NAME_ASC, CUSTOMER_ID_ASC};
        }
        return result;
    }

    @Override
    protected Object getValue(ObjectSet set, TableColumn column, int row) {
        Object result;
        int index = column.getModelIndex();
        switch (index) {
            case 5: {
                result = this.getPatientId(set);
                break;
            }
            case 6: {
                result = this.getPatientName(set);
                break;
            }
            case 7: {
                result = this.getPatientDescription(set);
                break;
            }
            case 8: {
                result = this.getContact(set);
                break;
            }
            default: {
                result = super.getValue(set, column, row);
            }
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel(boolean showCustomer, boolean showPatient, boolean showContact, boolean showIdentity, boolean showActive) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        if (showCustomer) {
            model.addColumn(CustomerPatientTableModel.createTableColumn(0, "customerpatientquery.customer"));
            model.addColumn(CustomerPatientTableModel.createTableColumn(1, "customerpatientquery.customer.name"));
            model.addColumn(CustomerPatientTableModel.createTableColumn(2, "customerpatientquery.customer.description"));
            if (showActive && this.showActiveForCustomer) {
                model.addColumn(CustomerPatientTableModel.createTableColumn(4, "table.imobject.active"));
            }
        }
        if (showContact) {
            model.addColumn(CustomerPatientTableModel.createTableColumn(8, "customerpatientquery.contact"));
        }
        if (showPatient) {
            model.addColumn(CustomerPatientTableModel.createTableColumn(5, "customerpatientquery.patient"));
            model.addColumn(CustomerPatientTableModel.createTableColumn(6, "customerpatientquery.patient.name"));
            model.addColumn(CustomerPatientTableModel.createTableColumn(7, "customerpatientquery.patient.description"));
            if (showActive && !this.showActiveForCustomer) {
                model.addColumn(CustomerPatientTableModel.createTableColumn(4, "table.imobject.active"));
            }
        }
        if (showIdentity) {
            model.addColumn(CustomerPatientTableModel.createTableColumn(3, "table.entity.identity"));
        }
        return model;
    }

    @Override
    protected CheckBox getActive(ObjectSet set) {
        Entity entity = this.showActiveForCustomer ? this.getEntity(set) : this.getPatient(set);
        return entity != null ? this.getActive((IMObject)entity) : null;
    }

    protected Party getPatient(ObjectSet set) {
        return (Party)set.get("patient");
    }

    private Long getPatientId(ObjectSet set) {
        Party patient = this.getPatient(set);
        return patient != null ? Long.valueOf(patient.getId()) : null;
    }

    private String getPatientName(ObjectSet set) {
        Party patient = this.getPatient(set);
        return patient != null ? patient.getName() : null;
    }

    private Component getPatientDescription(ObjectSet set) {
        Label result = null;
        Party patient = this.getPatient(set);
        if (patient != null) {
            Label label = LabelFactory.create();
            label.setText(patient.getDescription());
            if (this.patientRules.isDeceased(patient)) {
                Label deceased = LabelFactory.create((String)"patient.deceased", (String)"Patient.Deceased");
                result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, deceased});
            } else {
                result = label;
            }
        }
        return result;
    }

    private String getContact(ObjectSet set) {
        Contact contact = (Contact)set.get("contact");
        return contact != null ? contact.getDescription() : null;
    }
}

