/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import java.util.ArrayList;
import java.util.Arrays;
import nextapp.echo2.app.Extent;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.customer.CustomerPatientObjectSetQuery;
import org.openvpms.web.component.im.customer.CustomerResultSet;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.text.TextComponent;

public class CustomerObjectSetQuery
extends CustomerPatientObjectSetQuery {
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("customer", "name")};

    public CustomerObjectSetQuery(String[] shortNames) {
        super(shortNames, true, (Party)null);
        this.setDefaultSortConstraint(DEFAULT_SORT);
    }

    @Override
    public boolean selects(Reference reference) {
        CustomerResultSet set = (CustomerResultSet)this.createResultSet(null);
        set.setReferenceConstraint(reference);
        return set.hasNext();
    }

    @Override
    public Extent getHeight() {
        return this.getHeight(2);
    }

    @Override
    public QueryState getQueryState() {
        return new CustomerMemento(this);
    }

    @Override
    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        String patientWildcard = this.getWildcardedText((TextComponent)this.getPatient());
        String contactWildcard = this.getWildcardedText((TextComponent)this.getContact(), true);
        if (patientWildcard == null && sort != null && sort.length != 0) {
            ArrayList<SortConstraint> list = new ArrayList<SortConstraint>(Arrays.asList(sort));
            list.removeIf(constraint -> "patient".equals(constraint.getAlias()));
            sort = list.toArray(new SortConstraint[0]);
        }
        return new CustomerResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), patientWildcard, contactWildcard, this.getConstraints(), sort, this.getMaxResults(), this.isDistinct());
    }

    private static class CustomerMemento
    extends CustomerPatientObjectSetQuery.Memento {
        public CustomerMemento(CustomerPatientObjectSetQuery query) {
            super(query);
        }
    }
}

