/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.echo.factory.LabelFactory;

public class PhoneLink {
    private final PartyRules rules;
    private final ArchetypeService service;
    private final int length;

    public PhoneLink(PartyRules rules, ArchetypeService service) {
        this(rules, service, -1);
    }

    public PhoneLink(PartyRules rules, ArchetypeService service, int length) {
        this.rules = rules;
        this.service = service;
        this.length = length;
    }

    public Component getLink(Contact contact, boolean includeName) {
        Contacts contacts;
        String phone;
        Label result = null;
        if (contact != null && (phone = (contacts = new Contacts(this.service)).getPhone(contact)) != null) {
            String formattedPhone = this.rules.formatPhone(contact, includeName);
            String tooltip = null;
            if (this.length > 0 && formattedPhone.length() > this.length) {
                tooltip = formattedPhone;
                formattedPhone = ContactHelper.abbreviatePhone(contact, includeName, this.length, this.rules, this.service);
            }
            Label html = LabelFactory.html((String)("<a href=\"tel:" + StringEscapeUtils.escapeXml11((String)phone) + "\">" + StringEscapeUtils.escapeXml11((String)formattedPhone) + "</a>"));
            html.setStyleName("default");
            if (tooltip != null) {
                html.setToolTipText(tooltip);
            }
            result = html;
        }
        return result;
    }
}

