/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.AbstractContactEditor;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.system.ServiceHelper;

public class EmailEditor
extends AbstractContactEditor {
    private final String defaultEmailName = ContactHelper.getDefaultEmailName((ArchetypeService)ServiceHelper.getArchetypeService());

    public EmailEditor(Contact object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        PartyRules rules;
        String fullName;
        if (object.isNew() && parent instanceof Party && !StringUtils.isEmpty((CharSequence)(fullName = (rules = (PartyRules)ServiceHelper.getBean(CustomerRules.class)).getFullName((Party)parent, false)))) {
            object.setName(fullName);
        }
    }

    public String getName() {
        return this.getProperty("name").getString();
    }

    public String getEmailAddress() {
        return this.getProperty("emailAddress").getString();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateInternetAddress(validator);
    }

    private boolean validateInternetAddress(Validator validator) {
        boolean valid = false;
        String name = this.getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)this.defaultEmailName)) {
            name = null;
        }
        EmailAddress address = new EmailAddress(this.getEmailAddress(), name);
        String email = address.toString(true);
        try {
            new InternetAddress(email, true);
            valid = true;
        }
        catch (AddressException exception) {
            Property property = name != null ? this.getProperty("name") : this.getProperty("emailAddress");
            validator.add((Modifiable)property, new ValidatorError(property, exception.getMessage()));
        }
        return valid;
    }
}

