/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectTableCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;

public class ContactCollectionEditor
extends IMObjectTableCollectionEditor {
    private static final String PREFERRED = "preferred";

    public ContactCollectionEditor(CollectionProperty property, IMObject object, LayoutContext context) {
        super(new ContactCollectionPropertyEditor(property), object, context);
    }

    public void setExcludeUnmodifiedContacts(boolean exclude) {
        this.getCollectionPropertyEditor().setExcludeUnmodified(exclude);
    }

    @Override
    public IMObject create(String archetype) {
        boolean preferred;
        Contact contact = (Contact)this.getCollectionPropertyEditor().getUnmodified(archetype);
        if ((contact == null || this.getEditor((IMObject)contact).isModified()) && (contact = (Contact)super.create(archetype)) != null && (preferred = this.isPreferred((IMObject)contact))) {
            for (IMObject object : this.getCurrentObjects()) {
                if (!object.getArchetype().equals(contact.getArchetype()) || !this.isPreferred(object)) continue;
                IMObjectBean bean = this.getBean((IMObject)contact);
                bean.setValue(PREFERRED, (Object)false);
                break;
            }
        }
        return contact;
    }

    @Override
    protected void onCurrentEditorModified() {
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null) {
            Contact current = (Contact)editor.getObject();
            Property property = editor.getProperty(PREFERRED);
            if (property != null && property.getBoolean()) {
                for (IMObject c : this.getCurrentObjects()) {
                    IMObjectEditor contactEditor;
                    Contact contact = (Contact)c;
                    if (current.equals(contact) || !current.getArchetype().equals(contact.getArchetype()) || (contactEditor = this.getEditor((IMObject)contact)) == null) continue;
                    contactEditor.getProperty(PREFERRED).setValue(false);
                }
            }
        }
        super.onCurrentEditorModified();
    }

    @Override
    protected ContactCollectionPropertyEditor getCollectionPropertyEditor() {
        return (ContactCollectionPropertyEditor)super.getCollectionPropertyEditor();
    }

    @Override
    protected IMObjectEditor edit(IMObject object) {
        IMObjectEditor editor = super.edit(object);
        if (this.excludedFromValidation(editor) && !editor.isValid()) {
            this.enableNavigation(true);
        }
        return editor;
    }

    @Override
    protected boolean addCurrentEdits(Validator validator) {
        boolean valid = true;
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null) {
            if (!this.excludedFromValidation(editor)) {
                valid = editor.validate(validator);
                if (valid) {
                    this.addEdited(editor);
                }
            } else {
                this.addEdited(editor);
            }
        }
        return valid;
    }

    private boolean excludedFromValidation(IMObjectEditor editor) {
        return this.getCollectionPropertyEditor().excludeUnmodified() && editor.getObject().isNew() && !editor.isModified();
    }

    private boolean isPreferred(IMObject contact) {
        IMObjectBean bean = this.getBean(contact);
        return bean.hasNode(PREFERRED) && bean.getBoolean(PREFERRED);
    }

    private static class ContactCollectionPropertyEditor
    extends AbstractCollectionPropertyEditor {
        private final Set<IMObject> pending = new HashSet<IMObject>();
        private final Map<IMObject, IMObjectEditor> pendingEditors = new HashMap<IMObject, IMObjectEditor>();
        private boolean excludeUnmodified;

        ContactCollectionPropertyEditor(CollectionProperty property) {
            super(property);
        }

        public List<IMObject> getObjects() {
            List<IMObject> result;
            if (this.pending.isEmpty()) {
                result = super.getObjects();
            } else {
                result = new ArrayList(super.getObjects());
                for (IMObject object : this.pending) {
                    if (result.contains(object)) continue;
                    result.add(object);
                }
            }
            return result;
        }

        @Override
        public boolean add(IMObject object) {
            boolean added;
            if (this.excludeUnmodified && object.isNew()) {
                added = this.pending.add(object);
                if (added) {
                    this.resetValid();
                }
            } else {
                added = super.add(object);
            }
            return added;
        }

        @Override
        public boolean remove(IMObject object) {
            boolean removed = super.remove(object);
            if (this.pending.remove(object)) {
                removed = true;
                this.resetValid();
            }
            return removed;
        }

        @Override
        public boolean isModified() {
            boolean modified = super.isModified();
            if (!modified && !this.pendingEditors.isEmpty()) {
                for (IMObjectEditor editor : this.pendingEditors.values()) {
                    if (!editor.isModified()) continue;
                    modified = true;
                    break;
                }
            }
            return modified;
        }

        @Override
        public void clearModified() {
            super.clearModified();
            for (IMObjectEditor editor : this.pendingEditors.values()) {
                editor.clearModified();
            }
        }

        @Override
        public IMObjectEditor getEditor(IMObject object) {
            IMObjectEditor editor = this.pendingEditors.get(object);
            if (editor == null) {
                editor = super.getEditor(object);
            }
            return editor;
        }

        @Override
        public Collection<IMObjectEditor> getEditors() {
            Collection<IMObjectEditor> result;
            if (this.pendingEditors.isEmpty()) {
                result = super.getEditors();
            } else {
                result = new ArrayList<IMObjectEditor>(super.getEditors());
                for (IMObjectEditor object : this.pendingEditors.values()) {
                    if (result.contains(object)) continue;
                    result.add(object);
                }
            }
            return result;
        }

        @Override
        public void setEditor(IMObject object, IMObjectEditor editor) {
            if (object.isNew()) {
                if (editor == null) {
                    this.pendingEditors.remove(object);
                } else {
                    this.pendingEditors.put(object, editor);
                }
            } else {
                super.setEditor(object, editor);
            }
        }

        @Override
        protected boolean doValidation(Validator validator) {
            this.addPending();
            boolean result = validator.validate(this.getProperty());
            if (result) {
                result = this.validate(validator, super.getObjects());
            }
            return result;
        }

        @Override
        protected IMObjectEditor removeEdited(IMObject object) {
            IMObjectEditor editor = super.removeEdited(object);
            if (editor == null && (editor = this.pendingEditors.remove(object)) != null) {
                this.resetValid(false);
            }
            return editor;
        }

        @Override
        protected void doSave() {
            this.addPending();
            super.doSave();
        }

        private void addPending() {
            for (IMObject object : this.pending.toArray(new IMObject[0])) {
                IMObjectEditor editor = this.pendingEditors.get(object);
                if (editor == null || !editor.isModified()) continue;
                this.getProperty().add(object);
                super.setEditor(object, editor);
                this.pendingEditors.remove(object);
                this.pending.remove(object);
            }
        }

        void setExcludeUnmodified(boolean excludeUnmodified) {
            this.excludeUnmodified = excludeUnmodified;
        }

        boolean excludeUnmodified() {
            return this.excludeUnmodified;
        }

        IMObject getUnmodified(String archetype) {
            return archetype != null ? IMObjectHelper.getObject(archetype, this.pending) : null;
        }
    }
}

