/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.audit;

import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.popup.PopUp;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class AuditInfo
extends PopUp {
    private final AuditableIMObject object;
    private Date created;
    private Reference createdBy;
    private Date updated;
    private Reference updatedBy;

    public AuditInfo(AuditableIMObject object, IMObjectNames names) {
        this.object = object;
        this.setStyleName("AuditInfo");
        this.doLayout(names);
    }

    public void refresh(IMObjectNames names) {
        if (!(Objects.equals(this.created, this.object.getCreated()) && Objects.equals(this.createdBy, this.object.getCreatedBy()) && Objects.equals(this.updated, this.object.getUpdated()) && Objects.equals(this.updatedBy, this.object.getUpdatedBy()))) {
            this.doLayout(names);
        }
    }

    private void doLayout(IMObjectNames names) {
        this.setPopUp(this.createPopup(this.object, names));
        this.created = this.object.getCreated();
        this.createdBy = this.object.getCreatedBy();
        this.updated = this.object.getUpdated();
        this.updatedBy = this.object.getUpdatedBy();
        this.setVisible(!this.object.isNew());
    }

    private Component createPopup(AuditableIMObject object, IMObjectNames names) {
        Grid grid = GridFactory.create((int)3, (Component[])new Component[]{LabelFactory.create((String)"imobject.created"), this.getName(object.getCreatedBy(), names), this.getDate(object.getCreated())});
        if (object.getUpdated() != null && object.getUpdatedBy() != null) {
            grid.add((Component)LabelFactory.create((String)"imobject.updated"));
            grid.add((Component)this.getName(object.getUpdatedBy(), names));
            grid.add((Component)this.getDate(object.getUpdated()));
        }
        return grid;
    }

    private Label getName(Reference user, IMObjectNames names) {
        String name = names.getName(user);
        Label label = LabelFactory.text((String)name);
        if (name == null) {
            label.setText(Messages.get((String)"imobject.unknownauthor"));
            label.setStyleName("italic");
        }
        return label;
    }

    private Label getDate(Date date) {
        String text = date != null ? DateFormatter.formatDateTimeAbbrev((Date)date) : null;
        return LabelFactory.text((String)text);
    }
}

