/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.act.ActHierarchyFilter;
import org.openvpms.web.component.im.act.ActHierarchyIterator;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.PagedIMObjectTableModel;

public class PagedActHierarchyTableModel<T extends Act>
extends PagedIMObjectTableModel<T> {
    private String[] archetypes;
    private final int maxDepth;
    private boolean sortAscending = true;

    public PagedActHierarchyTableModel(IMObjectTableModel<T> model, String ... archetypes) {
        this(model, -1, archetypes);
    }

    public PagedActHierarchyTableModel(IMObjectTableModel<T> model, int maxDepth, String ... archetypes) {
        super(model);
        this.archetypes = archetypes;
        this.maxDepth = maxDepth;
    }

    public void setArchetypes(String[] archetypes) {
        this.archetypes = archetypes;
    }

    public String[] getArchetypes() {
        return this.archetypes;
    }

    public void setSortAscending(boolean ascending) {
        this.sortAscending = ascending;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    protected void setPage(List<T> objects) {
        List<T> acts = this.flattenHierarchy(objects, this.archetypes);
        this.getModel().setObjects(acts);
    }

    protected List<T> flattenHierarchy(List<T> objects, String[] archetypes) {
        ArrayList list = new ArrayList();
        CollectionUtils.addAll(list, this.createIterator(objects, archetypes));
        return list;
    }

    protected ActHierarchyIterator<T> createIterator(List<T> objects, String[] archetypes) {
        ActHierarchyFilter filter = new ActHierarchyFilter(archetypes, true);
        filter.setSortItemsAscending(this.sortAscending);
        return new ActHierarchyIterator<T>(objects, filter, this.maxDepth);
    }
}

