/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.act.ActFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActHierarchyLister<T extends Act> {
    private static final Logger log = LoggerFactory.getLogger(ActHierarchyLister.class);

    public List<T> list(T root, ActFilter<T> filter, int maxDepth) {
        Node<T> tree = this.buildTree(root, filter, maxDepth);
        ArrayList result = new ArrayList();
        return this.flattenTree(tree, result, filter);
    }

    protected List<T> flattenTree(Node<T> tree, List<T> values, ActFilter<T> filter) {
        values.add(((Node)tree).value);
        Comparator<Act> comparator = filter.getComparator(((Node)tree).value);
        for (Node<Act> child : this.sort(((Node)tree).children, comparator)) {
            this.flattenTree(child, values, filter);
        }
        return values;
    }

    protected List<Node<T>> sort(List<Node<T>> nodes, Comparator<T> comparator) {
        Comparator nodeComparator = (o1, o2) -> comparator.compare(((Node)o1).value, ((Node)o2).value);
        nodes.sort(nodeComparator);
        return nodes;
    }

    protected Node<T> buildTree(T root, ActFilter<T> filter, int maxDepth) {
        Node<T> tree = new Node<T>(root);
        HashMap nodes = new HashMap();
        HashMap acts = new HashMap();
        this.buildTree(root, root, filter, 2, maxDepth, tree, nodes, acts);
        return tree;
    }

    private void buildTree(T act, T root, ActFilter<T> filter, int depth, int maxDepth, Node<T> parent, Map<T, Node<T>> nodes, Map<Reference, T> acts) {
        List<T> children = filter.filter(act, root, acts);
        ArrayList<Node<Act>> added = new ArrayList<Node<Act>>();
        ArrayList<Node<T>> move = new ArrayList<Node<T>>();
        for (Act act2 : children) {
            Node<T> node = nodes.get(act2);
            if (node != null) {
                if (node == parent) {
                    log.warn("Attempt to add node to itself: " + act2.getObjectReference());
                    continue;
                }
                move.add(node);
                continue;
            }
            Node<Act> node2 = new Node<Act>(parent, act2);
            nodes.put(act2, node2);
            added.add(node2);
        }
        if (depth < maxDepth || maxDepth == -1) {
            for (Node node : added) {
                this.buildTree(node.value, root, filter, depth + 1, maxDepth, node, nodes, acts);
            }
        }
        ArrayList list = new ArrayList(move);
        block2: while (!list.isEmpty()) {
            Node node = (Node)list.remove(0);
            for (Node node2 : list) {
                if (node2.isChildOf(node)) {
                    move.remove(node2);
                    continue;
                }
                if (!node.isChildOf(node2)) continue;
                move.remove(node);
                continue block2;
            }
        }
        for (Node node : move) {
            if (node.getDepth() >= depth) continue;
            node.remove();
            parent.add(node);
        }
    }

    static class Node<T extends Act> {
        private final T value;
        private final List<Node<T>> children = new ArrayList<Node<T>>();
        private Node<T> parent;

        Node(T value) {
            this(null, value);
        }

        Node(Node<T> parent, T value) {
            this.value = value;
            if (parent != null) {
                parent.add(this);
            }
        }

        public void add(Node<T> child) {
            this.children.add(child);
            child.parent = this;
        }

        public void remove() {
            if (this.parent != null) {
                this.parent.children.remove(this);
                this.parent = null;
            }
        }

        public int getDepth() {
            Node<T> p = this.parent;
            int depth = 0;
            while (p != null) {
                p = p.parent;
                if (++depth <= 255) continue;
                log.warn("getDepth() depth greater than expected, bailing out");
                break;
            }
            return depth;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public boolean isChildOf(Node<T> node) {
            Node<T> p;
            int depth = 0;
            for (p = this.parent; p != null && p != node; p = p.getParent()) {
                if (++depth <= 255) continue;
                log.warn("isChildOf() node depth greater than expected, bailing out");
                break;
            }
            return p == node;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(StringUtils.leftPad((String)"", (int)this.getDepth(), (char)'-'));
            builder.append(this.value.getArchetype());
            builder.append(':');
            builder.append(this.value.getId());
            for (Node<T> child : this.children) {
                builder.append("\n");
                builder.append(child);
            }
            return builder.toString();
        }
    }
}

