/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.system.ServiceHelper;

public class ContextHelper {
    public static void setCustomer(Context context, Party customer) {
        Party patient;
        context.setCustomer(customer);
        if (customer != null && (patient = context.getPatient()) != null) {
            Reference ref = patient.getObjectReference();
            boolean found = false;
            for (Relationship relationship : customer.getEntityRelationships()) {
                Reference target = relationship.getTarget();
                if (target == null || !target.equals((Object)ref)) continue;
                found = true;
                break;
            }
            if (!found) {
                context.setPatient(null);
            }
        }
    }

    public static void setPatient(Context context, Party patient) {
        ContextHelper.setPatient(context, patient, true);
    }

    public static void setPatient(Context context, Party patient, boolean preserveCustomerIfNoRelationship) {
        if (patient == null) {
            context.setPatient(null);
        } else {
            Party customer = context.getCustomer();
            boolean found = false;
            if (customer != null) {
                Reference ref = customer.getObjectReference();
                for (Relationship relationship : patient.getEntityRelationships()) {
                    Reference source = relationship.getSource();
                    if (source == null || !source.equals((Object)ref)) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                context.setPatient(patient);
            } else if (preserveCustomerIfNoRelationship) {
                context.setPatient(null);
            } else {
                context.setPatient(patient);
                for (Relationship relationship : patient.getEntityRelationships()) {
                    Party owner;
                    Reference source = relationship.getSource();
                    if (!relationship.isA("entityRelationship.patientOwner") || !relationship.isActive() || (owner = (Party)IMObjectHelper.getObject(source, context)) == null) continue;
                    context.setCustomer(owner);
                    found = true;
                    break;
                }
                if (!found) {
                    context.setCustomer(null);
                }
            }
        }
    }

    public static Currency getPracticeCurrency(Context context) {
        Currency result = null;
        Party practice = context.getPractice();
        if (practice != null) {
            PracticeRules rules = ServiceHelper.getBean(PracticeRules.class);
            result = rules.getCurrency(practice);
        }
        return result;
    }
}

