/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webrender.ClientProperties;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.style.Style;
import org.openvpms.web.echo.style.UserStyleSheets;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class ContextApplicationInstance
extends SpringApplicationInstance {
    private final GlobalContext context;
    private final PracticeRules practiceRules;
    private final LocationRules locationRules;
    private final UserRules userRules;
    private final UserPreferences preferences;
    private final ContextListener locationListener;
    private Dimension resolution;
    private UserStyleSheets styleSheets;

    public ContextApplicationInstance(GlobalContext context, PracticeRules practiceRules, LocationRules locationRules, UserRules userRules, UserPreferences preferences) {
        this.context = context;
        this.practiceRules = practiceRules;
        this.locationRules = locationRules;
        this.userRules = userRules;
        this.preferences = preferences;
        this.initUser();
        this.initPractice();
        this.initLocation();
        this.initPrefs(preferences);
        this.locationListener = (key, value) -> this.updateLocation((Party)value);
        context.addListener("party.organisationLocation", this.locationListener);
    }

    public GlobalContext getContext() {
        return this.context;
    }

    public abstract void switchTo(IMObject var1);

    public abstract void switchTo(String var1);

    public Dimension getResolution() {
        if (this.resolution == null) {
            ContainerContext context = (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
            int width = this.getProperty(context, "width", "screenWidth", 1024);
            int height = this.getProperty(context, "height", "screenHeight", 768);
            this.resolution = new Dimension(width, height);
        }
        return this.resolution;
    }

    public void setResolution(Dimension resolution) {
        this.resolution = resolution;
    }

    @Resource
    public void setStyleSheets(UserStyleSheets styleSheets) {
        this.styleSheets = styleSheets;
    }

    public UserStyleSheets getStyleSheets() {
        return this.styleSheets;
    }

    public void setStyleSheet() {
        Dimension size = this.getResolution();
        this.setStyle(size.width, size.height);
    }

    public void setStyle(int width, int height) {
        try {
            Style style = this.styleSheets.getStyle(width, height);
            this.styleSheets.setStyle((ApplicationInstance)this, style);
            this.setStyleSheet(style.getStylesheet());
            this.setResolution(style.getSize());
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception, true);
        }
    }

    public UserPreferences getPreferences() {
        return this.preferences;
    }

    public static ContextApplicationInstance getInstance() {
        return (ContextApplicationInstance)ApplicationInstance.getActive();
    }

    public synchronized void dispose() {
        super.dispose();
        this.context.removeListener("party.organisationLocation", this.locationListener);
    }

    protected void clearContext() {
        for (IMObject object : this.context.getObjects()) {
            this.context.removeObject(object);
        }
    }

    private int getProperty(ContainerContext context, String queryStringName, String propertyName, int defaultValue) {
        int result = -1;
        if (context != null) {
            ClientProperties properties;
            String[] values;
            Map map = context.getInitialRequestParameterMap();
            if (map != null && (values = (String[])map.get(queryStringName)) != null && values.length == 1) {
                try {
                    result = Integer.parseInt(values[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (result == -1 && (properties = context.getClientProperties()) != null) {
                result = properties.getInt(propertyName, defaultValue);
            }
        }
        if (result <= 0) {
            result = defaultValue;
        }
        return result;
    }

    private void initUser() {
        User user;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && (user = this.userRules.getUser(auth)) != null) {
            this.context.setUser(user);
            if (this.userRules.isClinician(user)) {
                this.context.setClinician(user);
            }
        }
    }

    private void initPractice() {
        this.context.setPractice(this.practiceRules.getPractice());
    }

    private void initLocation() {
        Party practice = this.context.getPractice();
        User user = this.context.getUser();
        if (practice != null && user != null) {
            Party location = this.userRules.getDefaultLocation(user);
            if (location == null) {
                location = this.practiceRules.getDefaultLocation(practice);
            }
            this.context.setLocation(location);
            this.updateLocation(location);
        }
    }

    private void initPrefs(UserPreferences preferences) {
        User user = this.context.getUser();
        if (user != null) {
            preferences.initialise(user);
        }
    }

    private void updateLocation(Party location) {
        Party deposit = null;
        Entity till = null;
        Entity terminal = null;
        Entity workListView = null;
        Party stockLocation = null;
        if (location != null) {
            List terminals;
            deposit = this.locationRules.getDefaultDepositAccount(location);
            till = this.locationRules.getDefaultTill(location);
            workListView = this.locationRules.getDefaultWorkListView(location);
            stockLocation = this.locationRules.getDefaultStockLocation(location);
            if (till != null && (terminal = this.locationRules.getDefaultTerminal(till)) == null && !(terminals = this.locationRules.getTerminals(till)).isEmpty()) {
                terminal = (Entity)terminals.get(0);
            }
        }
        this.context.setDeposit(deposit);
        this.context.setTill(till);
        this.context.setTerminal(terminal);
        this.context.setScheduleView(null);
        this.context.setSchedule(null);
        this.context.setWorkListView(workListView);
        this.context.setWorkList(null);
        this.context.setStockLocation(stockLocation);
    }
}

