/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.alert.AccountTypeAlert;
import org.openvpms.web.component.alert.ActiveAlertLayoutStrategy;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class AlertViewer {
    private final Alert alert;
    private final Context context;
    private final HelpContext help;

    public AlertViewer(Alert alert, Context context, HelpContext help) {
        this.alert = alert;
        this.context = context;
        this.help = help;
    }

    public Component getComponent() {
        Act act;
        Column column = ColumnFactory.create();
        AccountType accountType = null;
        if (this.alert instanceof AccountTypeAlert) {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            act = (Act)service.create("act.customerAlert", Act.class);
            IMObjectBean bean = service.getBean((IMObject)act);
            AccountTypeAlert accountTypeAlert = (AccountTypeAlert)this.alert;
            bean.setValue("startTime", null);
            bean.setTarget("customer", (IMObject)accountTypeAlert.getCustomer());
            bean.setValue("alertType", (Object)accountTypeAlert.getAlertType().getCode());
            accountType = accountTypeAlert.getAccountType();
        } else {
            act = this.alert.getAlert();
        }
        if (act != null) {
            IMObjectViewer viewer = new IMObjectViewer((IMObject)act, null, new ActiveAlertLayoutStrategy(accountType), new DefaultLayoutContext(this.context, this.help));
            column.add(viewer.getComponent());
        }
        return column;
    }
}

