/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertViewer;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AlertDialog
extends ModalDialog {
    private final Alert alert;
    private final Context context;
    private final HelpContext help;
    private static final String EDIT_ID = "button.edit";

    public AlertDialog(Alert alert, Context context, HelpContext help) {
        super(Messages.format((String)"alert.dialog.title", (Object[])new Object[]{alert.getName()}), null, OK);
        this.alert = alert;
        this.context = context;
        this.help = help;
        if (alert.getAlert() != null) {
            this.addButton(EDIT_ID, this::onEdit);
        }
        this.resize("AlertDialog.size");
    }

    protected void doLayout() {
        this.setTitleBackground(this.alert.getColour());
        this.setTitleForeground(this.alert.getTextColour());
        AlertViewer viewer = new AlertViewer(this.alert, this.context, this.help);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{viewer.getComponent()}));
    }

    private void onEdit() {
        Act object = IMObjectHelper.reload(this.alert.getAlert());
        if (object != null) {
            DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, this.help);
            IMObjectEditor editor = layoutContext.getEditorFactory().create((IMObject)object, layoutContext);
            EditDialog dialog = ServiceHelper.getBean(EditDialogFactory.class).create(editor, this.context);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    AlertDialog.this.onOK();
                }
            });
            dialog.show();
        }
    }
}

